package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@SuppressWarnings("unused")
@Entity
@Table(name = "archive_libraries")
public class Library implements Serializable, Comparable<Library> {
    private static final long serialVersionUID = 8469633941559619115L;

    public static final short TYPE_STANDARD = 0;
    public static final short TYPE_OLD_LIBRARY = 1;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue
    private Long id;

    @Column(name = "library_nm", length = 120, nullable = false)
    private String libraryNm;

    @Column(name = "folder_nm", nullable = false)
    private String folderNm;

    @Column(name = "filepath")
    private String filepath;

    @Column(name = "library_type", nullable = false)
    private short libraryType = TYPE_STANDARD;

    @Column(name = "created_dt", nullable = false)
    @Temporal(TemporalType.TIMESTAMP)
    private Date createdDt = new Date();

    @Column(name = "updated_dt", nullable = false)
    @Temporal(TemporalType.TIMESTAMP)
    private Date updatedDt = new Date();


    public Library() {
    }


    public Date getCreatedDt() {
        return createdDt;
    }

    public void setCreatedDt(Date createdDt) {
        this.createdDt = createdDt;
    }

    public String getFolderNm() {
        return folderNm;
    }

    public void setFolderNm(String folderNm) {
        this.folderNm = folderNm;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLibraryNm() {
        return libraryNm;
    }

    public void setLibraryNm(String libraryNm) {
        this.libraryNm = libraryNm;
    }

    public String getFilepath() {
        return filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    public short getLibraryType() {
        return libraryType;
    }

    public void setLibraryType(short libraryType) {
        this.libraryType = libraryType;
    }

    public Date getUpdatedDt() {
        return updatedDt;
    }

    public void setUpdatedDt(Date updatedDt) {
        this.updatedDt = updatedDt;
    }


    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        final Library other = (Library) obj;
        return this.id == other.id;

    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = (int) (59 * hash + this.id);

        return hash;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.Libraries[id: %d, folderNm: %s, filepath: %s, libraryNm: %s]",
                id, folderNm, filepath, libraryNm);
    }

    public int compareTo(Library o) {
        return this.id.compareTo(o.id);
    }
}
