/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.common.RationalNumberUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("^.*?([^.]+?\\.[^.]+)$");
    private static final Pattern IP_PATTERN = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r\n?");

    public static String newlineToBr(String value) {
        if (value == null) {
            return null;
        }
        return NEWLINE_PATTERN.matcher(value).replaceAll("<br/>");
    }

    public static String doubleToFractionsString(Double number) {
        if (number == null) {
            return null;
        }
        RationalNumber rationalNumber = RationalNumberUtilities.getRationalNumber((double)number);
        return rationalNumber.numerator + "/" + rationalNumber.divisor;
    }

    public static void addNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
    }

    public static void sendErrorCode(HttpServletResponse response, int statusCode) {
        try {
            response.sendError(statusCode);
        }
        catch (IOException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static String makeKey(Class<?> klass, String suffix) {
        return String.format("%s.%s", klass.getName(), suffix);
    }

    public static Date min(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return null;
        }
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.getTime() < date2.getTime() ? date1 : date2;
    }

    public static Date max(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return null;
        }
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.getTime() < date2.getTime() ? date2 : date1;
    }

    public static void setCookieDomain(HttpServletRequest request, Cookie cookie) {
        Matcher matcher;
        String serverName = request.getServerName();
        if (!IP_PATTERN.matcher(serverName).matches() && (matcher = DOMAIN_PATTERN.matcher(serverName)).matches()) {
            cookie.setDomain("." + matcher.group(1));
        }
    }

    public static String encodeUrl(String value) {
        try {
            return URLEncoder.encode(value, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String decodeUrl(String value) {
        try {
            return URLDecoder.decode(value, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static List<Long> getLibrarySubLibriesIds(Library rootLibrary, List<Library> allLibraries) {
        ArrayList<Long> subLibrariesIds = new ArrayList<Long>();
        String path = rootLibrary.getFilepath();
        if (path != null) {
            File file = new File(path, rootLibrary.getFolderNm());
            try {
                Utils.getSubdirs(file, new FileFilter(){

                    public boolean accept(File file) {
                        String name = file.getName();
                        return file.isDirectory() && name.length() <= 255;
                    }
                }, subLibrariesIds, allLibraries);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return subLibrariesIds;
    }

    private static void getSubdirs(File file, FileFilter filter, List<Long> subLibIds, List<Library> allLibs) throws IOException {
        if (file == null) {
            return;
        }
        File[] subDirsTmp = file.listFiles(filter);
        if (subDirsTmp == null) {
            subDirsTmp = new File[]{};
        }
        List<File> subdirs = Arrays.asList(subDirsTmp);
        subdirs = new ArrayList<File>(subdirs);
        for (File subdir : subdirs) {
            Library subLib = Utils.matchPathToLibrary(subdir, allLibs);
            if (subLib == null) {
                return;
            }
            subLibIds.add(subLib.getId());
            Utils.getSubdirs(subdir, filter, subLibIds, allLibs);
        }
    }

    private static Library matchPathToLibrary(File path, List<Library> allLibraries) {
        for (Library lib : allLibraries) {
            File f;
            if (lib.getFilepath() == null || !path.equals(f = new File(lib.getFilepath(), lib.getFolderNm()))) continue;
            return lib;
        }
        return null;
    }

    public static void writeJSON(Object object, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue((Writer)response.getWriter(), object);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Utils() {
    }

    public static String md5Custom(String st) {
        MessageDigest messageDigest = null;
        byte[] digest = new byte[]{};
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(st.getBytes());
            digest = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        BigInteger bigInt = new BigInteger(1, digest);
        String md5Hex = bigInt.toString(16);
        while (md5Hex.length() < 32) {
            md5Hex = "0" + md5Hex;
        }
        return md5Hex;
    }

    public static String buildQueryString(Map<String, Object> map) {
        try {
            Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
            StringBuilder sb = new StringBuilder(map.size() * 8);
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                String key = entry.getKey();
                if (key != null) {
                    sb.append(URLEncoder.encode(key, DEFAULT_ENCODING));
                    sb.append("=");
                    Object value = entry.getValue();
                    String valueAsString = value != null ? URLEncoder.encode(value.toString(), DEFAULT_ENCODING) : "";
                    sb.append(valueAsString);
                    if (!it.hasNext()) continue;
                    sb.append("&");
                    continue;
                }
                assert (false) : String.format("Null key in query map: %s", map.entrySet());
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String buildQueryStringMulti(Map<String, String[]> map) {
        try {
            StringBuilder sb = new StringBuilder(map.size() * 8);
            Iterator<Map.Entry<String, String[]>> mapIterator = map.entrySet().iterator();
            while (mapIterator.hasNext()) {
                Map.Entry<String, String[]> entry = mapIterator.next();
                String key = entry.getKey();
                if (key != null) {
                    String keyEncoded = URLEncoder.encode(key, DEFAULT_ENCODING);
                    List<Object> values = Arrays.asList((Object[])entry.getValue());
                    sb.append(keyEncoded);
                    sb.append("=");
                    if (values != null) {
                        Iterator<Object> listIt = values.iterator();
                        while (listIt.hasNext()) {
                            Object valueObject = listIt.next();
                            sb.append(valueObject != null ? URLEncoder.encode(valueObject.toString(), DEFAULT_ENCODING) : "");
                            if (!listIt.hasNext()) continue;
                            sb.append("&");
                            sb.append(keyEncoded);
                            sb.append("=");
                        }
                    }
                    if (!mapIterator.hasNext()) continue;
                    sb.append("&");
                    continue;
                }
                assert (false) : String.format("Null key in query map: %s", map.entrySet());
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static <T> List<T> asList(T ... a) {
        if (a == null) {
            return new ArrayList();
        }
        return Arrays.asList(a);
    }

    public static <T> String join(Collection<T> elements, String separator) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<T> it = elements.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }
}

