package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.io.Serializable;

/**
 * Created by Serhii from Ubrainians for Imcode
 * on 09.06.16.
 */
@Embeddable
public class LibraryRolesPK implements Serializable {
	private static final long serialVersionUID = 7689216727735000414L;

	@Column(name="library_id", nullable=false)
	private int libraryId;

	@Column(name="role_id", nullable=false)
	private int roleId;


	public LibraryRolesPK() {
	}

	public LibraryRolesPK(int libraryId, int roleId) {
		this.libraryId = libraryId;
		this.roleId = roleId;
	}


	public int getlibraryId() {
		return libraryId;
	}

	public void setlibraryId(int libraryId) {
		this.libraryId = libraryId;
	}

	public int getRoleId() {
		return roleId;
	}

	public void setRoleId(int roleId) {
		this.roleId = roleId;
	}


	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}

		if (getClass() != obj.getClass()) {
			return false;
		}

		final LibraryRolesPK other = (LibraryRolesPK) obj;
		if (this.libraryId != other.libraryId) {
			return false;
		}

		if (this.roleId != other.roleId) {
			return false;
		}

		return true;
	}

	@Override
	public int hashCode() {
		int hash = 5;
		hash = 83 * hash + this.libraryId;
		hash = 83 * hash + this.roleId;

		return hash;
	}

	@Override
	public String toString() {
		return String.format("com.imcode.imcms.addon.imagearchive.entity.LibraryRolesPK[libraryId: %d, roleId: %d]",
				libraryId, roleId);
	}
}
