package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

@Entity
@Table(name = "categories")
public class Category implements Serializable, Comparable<Category> {
    private static final long serialVersionUID = 7533187253952781894L;

    @Id
    @Column(name = "category_id", nullable = false)
    @GeneratedValue
    private Long id;

    @Column(name = "name", length = 128, nullable = false)
    private String name;

    @Column(name = "description", length = 500)
    private String description;

    @ManyToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    @JoinTable(
            name = "image_categories",
            inverseJoinColumns = @JoinColumn(name = "image_id", nullable = false),
            joinColumns = @JoinColumn(name = "category_id", nullable = false)
    )
    private List<Image> images;

//    @Column(name="image", length=255, nullable=false)
//    private String image;


    public Category() {
    }

    public Category(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

//    public String getImage() {
//        return image;
//    }
//
//    public void setImage(String image) {
//        this.image = image;
//    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

//    public CategoryTypes getType() {
//        return type;
//    }
//
//    public void setType(CategoryTypes type) {
//        this.type = type;
//    }
//
//    public int getTypeId() {
//        return typeId;
//    }
//
//    public void setTypeId(int typeId) {
//        this.typeId = typeId;
//    }
//

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        final Category other = (Category) obj;

        return this.id.equals(other.id);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = (int) (97 * hash + this.id);

        return hash;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.Categories[id: %d, name: %s]",
                id, name);
    }

    public List<Image> getImages() {
        return images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public int compareTo(Category o) {
        return this.id.compareTo(o.getId());
    }
}
