/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.command.SearchImageCommand;
import com.imcode.imcms.addon.imagearchive.comparators.CategoryComparator;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import com.imcode.imcms.addon.imagearchive.util.PageResult;
import com.imcode.imcms.addon.imagearchive.util.Pagination;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import com.imcode.imcms.addon.imagearchive.validator.SearchImageValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SearchImageController {
    private static final Log log = LogFactory.getLog(SearchImageController.class);
    private static final Pattern LOCAL_PAGE_PATTERN = Pattern.compile("/client/archive/page/(\\d+)?");
    private static final Pattern PAGE_PATTERN = Pattern.compile("/archive/page/(\\d+)?");
    private static final String PAGINATION_KEY = Utils.makeKey(SearchImageController.class, (String)"pagination");
    private static final String COMMAND_KEY = Utils.makeKey(SearchImageController.class, (String)"command");
    @Autowired
    private Facade facade;

    private static int getPage(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        Pattern pattern = requestURI.startsWith("/archive") ? PAGE_PATTERN : LOCAL_PAGE_PATTERN;
        Matcher matcher = pattern.matcher(requestURI);
        int page = 0;
        if (matcher.find()) {
            try {
                page = Integer.parseInt(matcher.group(1), 10);
                page = Math.max(page - 1, 0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return page;
    }

    @RequestMapping(value={"/archive", "/"})
    public ModelAndView indexHandler(@ModelAttribute(value="search") SearchImageCommand command, BindingResult result, @RequestParam(required=false) String returnTo, HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException {
        User user = ClientUtils.getLoggedInUser(request);
        if (user == null) {
            ClientUtils.redirectToLogin(response);
            return null;
        }
        SearchImageCommand temporaryCommand = new SearchImageCommand();
        temporaryCommand.copyFrom(command);
        returnTo = StringUtils.trimToNull((String)returnTo);
        if (returnTo != null) {
            session.setAttribute("returnToImcms", (Object)StringEscapeUtils.unescapeHtml4((String)returnTo));
        }
        ModelAndView mav = new ModelAndView("search_image");
        Pagination pag = Pagination.getPagination((HttpSession)session, (String)PAGINATION_KEY, (int)10);
        if (request.getParameter("show") == null) {
            SearchImageCommand cmd = (SearchImageCommand)session.getAttribute(COMMAND_KEY);
            if (cmd != null) {
                command.copyFrom(cmd);
            }
        } else {
            session.setAttribute(COMMAND_KEY, (Object)command);
            pag.setCurrentPage(0);
        }
        if (command.isClear()) {
            command.copyFrom(new SearchImageCommand());
        }
        mav.addObject("search", (Object)command);
        HashSet<Category> categories = new HashSet<Category>();
        for (Role role : user.getRoles()) {
            categories.addAll(this.facade.getRoleService().getUsableRoleCategories(role.getId()));
        }
        List keywords = this.facade.getKeywordService().getKeywords();
        ArrayList artists = new ArrayList(this.facade.getExifService().getAllArtists());
        ArrayList sortedCategories = new ArrayList(categories);
        sortedCategories.sort(new CategoryComparator());
        mav.addObject("categories", sortedCategories);
        mav.addObject("keywords", (Object)keywords);
        mav.addObject("artists", artists);
        SearchImageValidator validator = new SearchImageValidator(categories);
        ValidationUtils.invokeValidator((Validator)validator, (Object)temporaryCommand, (Errors)result);
        if (result.hasErrors()) {
            return mav;
        }
        session.setAttribute(COMMAND_KEY, (Object)command);
        pag.setPageSize(command.getResultsPerPage());
        PageResult imagePageResult = this.facade.getImageService().searchImages(pag, temporaryCommand);
        Collection images = imagePageResult.getResult();
        pag = imagePageResult.getPagination();
        mav.addObject("imageCount", (Object)pag.getAllElementsCount());
        mav.addObject("images", (Object)images);
        mav.addObject("pag", (Object)pag);
        mav.addObject("user", (Object)user);
        return mav;
    }

    @RequestMapping(value={"/page/*"})
    public ModelAndView pageHandler(HttpServletRequest request, @ModelAttribute(value="search") SearchImageCommand command, BindingResult result, HttpServletResponse response, HttpSession session) {
        User user = ClientUtils.getLoggedInUser(request);
        if (user == null) {
            ClientUtils.redirectToLogin(response);
            return null;
        }
        command = (SearchImageCommand)session.getAttribute(COMMAND_KEY);
        if (command == null) {
            return new ModelAndView("redirect:/archive/");
        }
        Pagination pag = Pagination.getPagination((HttpSession)session, (String)PAGINATION_KEY, (int)10);
        pag.setCurrentPage(SearchImageController.getPage(request));
        ModelAndView mav = new ModelAndView("search_image");
        mav.addObject("search", (Object)command);
        List keywords = this.facade.getKeywordService().getKeywords();
        ArrayList artists = new ArrayList(this.facade.getExifService().getAllArtists());
        mav.addObject("keywords", (Object)keywords);
        mav.addObject("artists", artists);
        HashSet<Category> categories = new HashSet<Category>();
        for (Role role : user.getRoles()) {
            categories.addAll(this.facade.getRoleService().getUsableRoleCategories(role.getId()));
        }
        ArrayList sortedCategories = new ArrayList(categories);
        sortedCategories.sort(new CategoryComparator());
        mav.addObject("categories", sortedCategories);
        SearchImageCommand temporaryCommand = new SearchImageCommand();
        temporaryCommand.copyFrom(command);
        SearchImageValidator validator = new SearchImageValidator(categories);
        ValidationUtils.invokeValidator((Validator)validator, (Object)temporaryCommand, (Errors)result);
        if (result.hasErrors()) {
            return mav;
        }
        pag.setPageSize(command.getResultsPerPage());
        PageResult imagePageResult = this.facade.getImageService().searchImages(pag, temporaryCommand);
        Collection images = imagePageResult.getResult();
        pag = imagePageResult.getPagination();
        mav.addObject("imageCount", (Object)pag.getAllElementsCount());
        mav.addObject("images", (Object)images);
        mav.addObject("pag", (Object)pag);
        mav.addObject("user", (Object)user);
        return mav;
    }
}

