package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class Facade {
    private final Config config;
    private final UserService userService;
    private final RoleService roleService;
    private final ExifService exifService;
    private final ImcmsImageService imcmsImageService;
    private final CategoryTypeService categoryTypeService;
    private final MessageSource messageSource;
    private final FileService fileService;
    private final ImageService imageService;
    private final CategoryService categoryService;
    private final KeywordService keywordService;

    @Autowired
    public Facade(ImcmsImageService imcmsImageService,
                  @Qualifier("remoteImageService") ImageService imageService,
                  @Qualifier("remoteKeywordService") KeywordService keywordService,
                  @Qualifier("remoteFileService") FileService fileService,
                  @Qualifier("remoteExifService") ExifService exifService,
                  CategoryService categoryService,
                  CategoryTypeService categoryTypeService,
                  UserService userService,
                  RoleService roleService,
                  MessageSource messageSource,
                  Config config) {

        this.imcmsImageService = imcmsImageService;
        this.imageService = imageService;
        this.keywordService = keywordService;
        this.fileService = fileService;
        this.categoryService = categoryService;
        this.categoryTypeService = categoryTypeService;
        this.messageSource = messageSource;
        this.exifService = exifService;
        this.config = config;
        this.userService = userService;
        this.roleService = roleService;
    }

    public ExifService getExifService() {
        return exifService;
    }

    public Config getConfig() {
        return config;
    }

    public FileService getFileService() {
        return fileService;
    }

    public ImageService getImageService() {
        return imageService;
    }

    public CategoryService getCategoryService() {
        return categoryService;
    }

    public KeywordService getKeywordService() {
        return keywordService;
    }

    public RoleService getRoleService() {
        return roleService;
    }

    public UserService getUserService() {
        return userService;
    }

    public ImcmsImageService getImcmsImageService() {
        return imcmsImageService;
    }

    public MessageSource getMessageSource() {
        return messageSource;
    }

    public CategoryTypeService getCategoryTypeService() {
        return categoryTypeService;
    }
}
