/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.tag.func;

import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.common.RationalNumberUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r\n?");

    public static String newlineToBr(String value) {
        if (value == null) {
            return null;
        }
        return NEWLINE_PATTERN.matcher(value).replaceAll("<br/>");
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtils.abbreviate((String)str, (int)maxWidth);
    }

    public static <T> String join(Collection<T> elements, String separator) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<T> it = elements.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String doubleToFractionsString(Double number) {
        if (number == null) {
            return null;
        }
        RationalNumber rationalNumber = RationalNumberUtilities.getRationalNumber((double)number);
        return rationalNumber.numerator + "/" + rationalNumber.divisor;
    }

    public static boolean canAccessExternalFiles(PageContext pageContext) {
        return ClientUtils.isUserSuperAdmin((HttpServletRequest)pageContext.getRequest());
    }

    public static boolean canAccessPreferences(PageContext pageContext) {
        return ClientUtils.isUserSuperAdmin((HttpServletRequest)pageContext.getRequest());
    }
}

