package com.imcode.imcms.addon.imagearchive.tag;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.comparators.FileComparator;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Prints out library sub-folders recursively as html listByNamedParams
 * Used in external files for library tree rendering
 */
public class LibraryChildren extends TagSupport {

    private LibrariesDto library;
    private LibrariesDto currentLibrary;

    @Override
    public int doStartTag() throws JspException {
        String path = getLibrary().getFilepath();
        if (path != null) {
            File file = new File(path, getLibrary().getFolderNm());
            try {
                JspWriter out = pageContext.getOut();
                LibrariesDto lib = getLibrary();
                final String libFullPath = lib.getFullPath();

                String currentLibraryClass = defineCurrentLibraryClass(libFullPath);

                out.print("<li data-library-id='" + libFullPath + "'>"
                        + "<span" + currentLibraryClass + ">" + lib.getFolderNm() + "</span>");

                getSubdirs(file, new FileFilter() {
                    final int MAXIMUM_LENGTH = 255;

                    public boolean accept(File file) {
                        return (file.isDirectory() && (file.getName().length() <= MAXIMUM_LENGTH));
                    }
                }, out);
                out.print("</li>");
            } catch (Exception e) {
                throw new JspException(e);
            }
        }

        return SKIP_BODY;
    }

    private String defineCurrentLibraryClass(String libraryFullPath) {
        return (getCurrentLibrary().getFullPath().equals(libraryFullPath))
                ? " class=\"currentLibrary\""
                : "";
    }

    private void getSubdirs(File file, FileFilter filter, JspWriter output) throws IOException {
        if (file == null) {
            return;
        }

        File[] subDirsTmp = file.listFiles(filter);
        if (subDirsTmp == null) {
            subDirsTmp = new File[0];
        }

        List<File> subDirs = new ArrayList<File>(Arrays.asList(subDirsTmp));
        Collections.sort(subDirs, new FileComparator());

        for (File subdir : subDirs) {

            output.print("<ul>");

            String currentLibraryClass = (getCurrentLibrary().getFullPath().equals(subdir.getAbsolutePath()))
                    ? " class='currentLibrary'"
                    : "";

            output.print("<li data-library-id='" + subdir.getAbsolutePath() + "'>"
                    + "<span" + currentLibraryClass + ">" + subdir.getName() + "</span>");
            getSubdirs(subdir, filter, output);

            output.print("</li>");
            output.print("</ul>");
        }
    }

    /**
     * Library to output children for
     */
    public LibrariesDto getLibrary() {
        return library;
    }

    public void setLibrary(LibrariesDto library) {
        this.library = library;
    }

    /**
     * Current library
     */
    public LibrariesDto getCurrentLibrary() {
        return currentLibrary;
    }

    public void setCurrentLibrary(LibrariesDto currentLibrary) {
        this.currentLibrary = currentLibrary;
    }
}
