package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.controller.web.RestoreSessionController;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/**
 * Session listener, holds last user metaId after session timeout
 *
 * @author Serhii from Ubrainians for Imcode
 * @since 1.0.2
 */
public class SessionListener implements HttpSessionListener {

    /**
     * Map that holds pairs userId - last metaId
     */
    private static Map<Long, Integer> usersToLastMetaId = new WeakHashMap<Long, Integer>();

    // Public constructor is required by servlet spec
    public SessionListener() {
    }

    public static Integer getLastDocumentFor(long userId) {
        return usersToLastMetaId.remove(userId);
    }

    public static void saveLastDocument(Long userId, Integer lastMetaId) {
        usersToLastMetaId.put(userId, lastMetaId);
    }

    /**
     * Clean user history to prevent memory leaks
     */
    public void sessionCreated(HttpSessionEvent event) {
        final HttpSession session = event.getSession();
        final User user = ClientUtils.getUserFromSession(session);

        if (user != null) {
            getLastDocumentFor(user.getId());
        }
    }

    /**
     * Saves userId and it's last document from session history for nex restoring in
     * {@link RestoreSessionController} after login
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        final HttpSession session = event.getSession();
        final User user = ClientUtils.getUserFromSession(session);

        if (user != null) {
            Long userId = user.getId();

            Integer lastMetaId = 1001; // start doc as default
            @SuppressWarnings("unchecked")
            final List<Integer> history = (List<Integer>) session.getAttribute("history");

            if ((history != null) && (history.size() > 0)) {
                lastMetaId = history.get(history.size() - 1);
            }

            saveLastDocument(userId, lastMetaId);
        }
    }
}
