/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionListener
implements HttpSessionListener {
    private static Map<Long, Integer> usersToLastMetaId = new WeakHashMap<Long, Integer>();

    public static Integer getLastDocumentFor(long userId) {
        return usersToLastMetaId.remove(userId);
    }

    public static void saveLastDocument(Long userId, Integer lastMetaId) {
        usersToLastMetaId.put(userId, lastMetaId);
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        User user = ClientUtils.getUserFromSession(session);
        if (user != null) {
            SessionListener.getLastDocumentFor(user.getId());
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        User user = ClientUtils.getUserFromSession(session);
        if (user != null) {
            Long userId = user.getId();
            Integer lastMetaId = 1001;
            List history = (List)session.getAttribute("history");
            if (history != null && history.size() > 0) {
                lastMetaId = (Integer)history.get(history.size() - 1);
            }
            SessionListener.saveLastDocument(userId, lastMetaId);
        }
    }
}

