package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.repository.UserRepository;
import com.imcode.imcms.addon.imagearchive.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Service
@Transactional
public class UserServiceImpl implements UserService {
    private static final Log log = LogFactory.getLog(UserService.class);

    @Autowired
    private UserRepository userRepository;

    public List<Role> findUserRoles(long userId) {
        return new ArrayList<Role>(userRepository.findOne(userId).getRoles());
    }

    public User findUserById(long userId) {
        return userRepository.findOne(userId);
    }

    public List<User> getAll() {
        return userRepository.findAll();
    }
}
