package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.command.SaveRoleCategoriesCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryRoles;
import com.imcode.imcms.addon.imagearchive.entity.Role;

import java.util.Collection;
import java.util.List;

public interface RoleService {
    Role getRoleById(int roleId);

    Role getRoleByName(String name);

    List<Role> getAllRoles();

    List<CategoryRoles> getCategoryRolesByRole(Role role);

    List<Role> getRolesByCategoryId(int id);

    List<Category> getAllRoleCategories(int id);

    List<Category> getUsableRoleCategories(int id);

    List<Category> getUsableRoleCategories(int... id);

    List<Category> getChangeableRoleCategories(int id);

    List<Category> getChangeableRoleCategories(int... id);

    List<Category> getUsableRoleCategories(Role role);

    List<Category> getUsableRoleCategories(Role... roles);

    List<Category> getChangeableRoleCategories(Role role);

    List<Category> getChangeableRoleCategories(Role... roles);

    void assignCategoryRoles(Role role, List<SaveRoleCategoriesCommand.CategoryRight> categoryRights);

    Collection<Role> getRoleById(Collection<Integer> allLibraryRolesIds);
}
