/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.tag;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class LibraryChildren
extends TagSupport {
    private LibrariesDto library;
    private LibrariesDto currentLibrary;

    public int doStartTag() throws JspException {
        String path = this.getLibrary().getFilepath();
        if (path != null) {
            File file = new File(path, this.getLibrary().getFolderNm());
            try {
                JspWriter out = this.pageContext.getOut();
                LibrariesDto lib = this.getLibrary();
                String libFullPath = lib.getFullPath();
                String currentLibraryClass = this.defineCurrentLibraryClass(libFullPath);
                out.print("<li data-library-id='" + libFullPath + "'><span" + currentLibraryClass + ">" + lib.getFolderNm() + "</span>");
                this.getSubdirs(file, new FileFilter(){
                    final int MAXIMUM_LENGTH = 255;

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() && file.getName().length() <= 255;
                    }
                }, out);
                out.print("</li>");
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
        return 0;
    }

    private String defineCurrentLibraryClass(String libraryFullPath) {
        return this.getCurrentLibrary().getFullPath().equals(libraryFullPath) ? " class=\"currentLibrary\"" : "";
    }

    private void getSubdirs(File file, FileFilter filter, JspWriter output) throws IOException {
        if (file == null) {
            return;
        }
        File[] subDirsTmp = file.listFiles(filter);
        if (subDirsTmp == null) {
            subDirsTmp = new File[]{};
        }
        ArrayList<File> subDirs = new ArrayList<File>(Arrays.asList(subDirsTmp));
        Collections.sort(subDirs);
        for (File subdir : subDirs) {
            output.print("<ul>");
            String currentLibraryClass = this.getCurrentLibrary().getFullPath().equals(subdir.getAbsolutePath()) ? " class='currentLibrary'" : "";
            output.print("<li data-library-id='" + subdir.getAbsolutePath() + "'><span" + currentLibraryClass + ">" + subdir.getName() + "</span>");
            this.getSubdirs(subdir, filter, output);
            output.print("</li>");
            output.print("</ul>");
        }
    }

    public LibrariesDto getLibrary() {
        return this.library;
    }

    public void setLibrary(LibrariesDto library) {
        this.library = library;
    }

    public LibrariesDto getCurrentLibrary() {
        return this.currentLibrary;
    }

    public void setCurrentLibrary(LibrariesDto currentLibrary) {
        this.currentLibrary = currentLibrary;
    }
}

