package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryType;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRepository;
import com.imcode.imcms.addon.imagearchive.repository.CategoryTypeRepository;
import com.imcode.imcms.addon.imagearchive.service.CategoryService;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;

@Service
@Transactional
public class CategoryServiceImpl implements CategoryService {
    @Autowired
    private CategoryRepository repository;

    @Autowired
    private CategoryTypeRepository typeRepository;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean existsCategory(final String categoryName) {
        return repository.findByName(categoryName) != null;
    }

    public Category createCategory(final String categoryName, final Integer typeId) throws CategoryExistsException {
        if (repository.findByName(categoryName) != null) {
            throw new CategoryExistsException();
        }

        CategoryType categoryType = typeRepository.findOne(typeId);
        Category category = new Category(categoryName, categoryType);

        return repository.save(category);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Category getCategory(final Long categoryId) {
        return repository.findOne(categoryId);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<Category> getCategories() {
        return repository.findAll();
    }

    @Transactional
    public void deleteCategory(final Long categoryId) {
        repository.delete(categoryId);
    }

    public void updateCategory(final Long categoryId, final String categoryName) throws CategoryExistsException {
        Category existsCategory = repository.findOne(categoryId);

        if (existsCategory != null && repository.findByName(categoryName) == null) {
            existsCategory.setName(categoryName);
            repository.save(existsCategory);
        }
    }

    public Category getCategory(String name) {
        return repository.findByName(name);
    }

    @Transactional
    public List<Category> getCategories(Collection<Long> categoriesId) {
        return repository.findAll(categoriesId);
    }

    @Transactional
    public List<Category> getCategories(Image image) {
        final List<Long> categoriesId = image.getCategories();
        return repository.findAll(categoriesId);
    }
}
