package com.imcode.imcms.addon.imagearchive.tag;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.filter.Filters;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;

/**
 * Prints out library sub-folders recursively as html listByNamedParams
 * Used in external files for library tree rendering
 */
public class LibraryChildren extends TagSupport {

    private LibrariesDto library;
    private LibrariesDto currentLibrary;
    private List<LibrariesDto> libraries;

    @Override
    public int doStartTag() throws JspException {
        String path = getLibrary().getFilepath();
        if (path != null) {
            File file = new File(path, getLibrary().getFolderNm());
            try {
                JspWriter out = pageContext.getOut();
                LibrariesDto lib = getLibrary();
                final Long libId = lib.getId();

                String currentLibraryClass = defineCurrentLibraryClass(libId);

                out.print("<li data-library-id='" + libId + "'>"
                        + "<span" + currentLibraryClass + ">" + lib.getLibraryNm() + "</span>");

                getSubdirs(file, Filters.subDirectoriesFileFilter(), out);
                out.print("</li>");
            } catch (Exception e) {
                throw new JspException(e);
            }
        }

        return SKIP_BODY;
    }

    private String defineCurrentLibraryClass(Long libraryId) {
        return (getCurrentLibrary().getId().equals(libraryId))
                ? " class=\"currentLibrary\""
                : "";
    }

    private void getSubdirs(File file, FileFilter filter, JspWriter output) throws IOException {
        if (file == null) {
            return;
        }

        File[] subDirsTmp = file.listFiles(filter);
        if (subDirsTmp == null) {
            subDirsTmp = new File[0];
        }

        for (File subdir : subDirsTmp) {
            LibrariesDto subLib = matchPathToLibrary(subdir);

            if (subLib == null) {
                continue;
            }

            output.print("<ul>");

            String currentLibraryClass = (getCurrentLibrary().getId().equals(subLib.getId()))
                    ? " class='currentLibrary'"
                    : "";

            output.print("<li data-library-id='" + subLib.getId() + "'>"
                    + "<span" + currentLibraryClass + ">" + subdir.getName() + "</span>");
            getSubdirs(subdir, filter, output);

            output.print("</li>");
            output.print("</ul>");
        }
    }

    private LibrariesDto matchPathToLibrary(File path) {
        for (LibrariesDto lib : getLibraries()) {
            if (lib.getFilepath() != null) {
                File f = new File(lib.getFilepath(), lib.getFolderNm());
                if (path.equals(f)) {
                    return lib;
                }
            }
        }

        return null;
    }

    /**
     * Library to output children for
     */
    public LibrariesDto getLibrary() {
        return library;
    }

    public void setLibrary(LibrariesDto library) {
        this.library = library;
    }

    /**
     * Current library
     */
    public LibrariesDto getCurrentLibrary() {
        return currentLibrary;
    }

    public void setCurrentLibrary(LibrariesDto currentLibrary) {
        this.currentLibrary = currentLibrary;
    }

    /**
     * List of all libraries available to the user
     */
    public List<LibrariesDto> getLibraries() {
        return libraries;
    }

    public void setLibraries(List<LibrariesDto> libraries) {
        this.libraries = libraries;
    }
}
