package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.entity.LibraryRoles;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.filter.Filters;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.LibraryService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.util.*;

@Service
@Transactional
public class LibraryServiceImpl implements LibraryService {
    private static final Log log = LogFactory.getLog(LibraryServiceImpl.class);

    @Autowired
    private Facade facade;

    @Autowired
    private LibraryRepository libraryRepository;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Library findLibraryById(final Long libraryId) {
        return libraryRepository.findOne(libraryId);
    }

    /**
     * @deprecated do not use this method any more
     */
    @Deprecated
    public void syncLibraryFolders() {
        syncOldLibraryFolders(Library.TYPE_OLD_LIBRARY);
        syncOldLibraryFolders(Library.TYPE_STANDARD);
    }

    /**
     * @deprecated do not use this method any more, there is no any reason for library deleting
     */
    @Deprecated
    private void syncOldLibraryFolders(short typeOldLibrary) {
        File[] oldLibraryFiles = facade.getConfig().getImcmsOldLibraryPaths();
        Set<File> files = new HashSet<File>();
        for (File f : oldLibraryFiles) {
            List<File> tmp = facade.getFileService().getSubdirs(f, Filters.subDirectoriesFileFilter());

            files.addAll(tmp);
        }

        CollectionUtils.addAll(files, oldLibraryFiles);

        if (files.isEmpty()) {
            libraryRepository.deleteByLibraryType(typeOldLibrary);
        }

        List<Library> existingLibraries = libraryRepository.findByLibraryType(typeOldLibrary);
        List<Library> toDelete = new LinkedList<Library>();

        for (Library lib : existingLibraries) {
            String folderNm = lib.getFolderNm();
            String filepath = lib.getFilepath();
            File file = new File(filepath, folderNm);

            if (!files.contains(file)) {
                toDelete.add(lib);
            } else {
                files.remove(file);
            }
        }

        if (!toDelete.isEmpty()) {
//            libraryRepository.delete(toDelete);
            for (Library library : toDelete) {
                // use iterable deleting with logging because sometimes we get errors
                try {
                    Collection<LibraryRoles> libraryRoles = facade.getLibraryRolesService()
                            .findLibraryRolesByLibraryId(library.getId());

                    facade.getLibraryRolesService().delete(libraryRoles);
                    libraryRepository.delete(library);
                } catch (Exception e) {
                    log.error(String.format(new Date() + ": Error deleting library %s", library.toString()), e);
                }
            }
        }

        for (File file : files) {
            final String folderNm = file.getName();
            final String filePath = StringUtils.substring(folderNm, 0, 120);

            if (libraryRepository.findByFolderNameAndFilePath(folderNm, filePath) != null) {
                Library lib = new Library();
                lib.setFolderNm(folderNm);
                lib.setLibraryNm(filePath);
                lib.setFilepath(file.getParent());
                lib.setLibraryType(typeOldLibrary);

                try {
                    libraryRepository.save(lib);
                } catch (Exception e) {
                    log.error(String.format(new Date() + ": Library already exist,  %s", lib.toString()), e);
                }
            }
        }
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<Library> getAllLibraries() {
        return libraryRepository.findAll();
    }

    public List<LibrariesDto> librariesToDto(List<Library> libraries) {
        List<LibrariesDto> librariesDtos = new LinkedList<LibrariesDto>();

        for (Library library : libraries) {
            LibrariesDto librariesDto = convertToLibraryDto(library);
            librariesDtos.add(librariesDto);
        }

        return librariesDtos;
    }

    public LibrariesDto convertToLibraryDto(Library library) {
        LibrariesDto librariesDto = new LibrariesDto();
        librariesDto.setId(library.getId());
        librariesDto.setLibraryNm(library.getLibraryNm());
        librariesDto.setFilepath(library.getFilepath());
        librariesDto.setFolderNm(library.getFolderNm());

        return librariesDto;
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public LibrariesDto findLibraryDtoById(Long id) {
        return convertToLibraryDto(libraryRepository.findOne(id));
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<LibrariesDto> findLibraryDtos() {
        return librariesToDto(libraryRepository.findAll());
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Collection<Role> getAllRoles() {
        final Collection<LibraryRoles> allLibraryRoles = facade.getLibraryRolesService().findAll();
        Collection<Integer> allLibraryRolesIds = new ArrayList<Integer>();

        for (LibraryRoles libraryRole : allLibraryRoles) {
            allLibraryRolesIds.add(libraryRole.getRoleId());
        }

        Collection<Role> roles = facade.getRoleService().getRoleById(allLibraryRolesIds);

        return roles;
    }
}
