package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.filter.SessionListener;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletResponse;

/**
 * Tries to restore previous session for user
 *
 * @author Serhii from Ubrainians for Imcode
 * @since 1.0.2
 */
@Controller
public class RestoreSessionController {

    /**
     * Returns last document for user or null if user has no last doc
     * Note that after receiving non null response user will be removed from history
     *
     * @param userId - id of interested user
     * @see SessionListener
     */
    @RequestMapping("/userLastDocuments/{userId}")
    public void getLastDoc(@PathVariable("userId") Long userId,
                           HttpServletResponse response) {

        final Integer docFromHistory = SessionListener.getLastDocumentFor(userId);
        Utils.writeJSON(docFromHistory, response);
    }
}
