package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.dto.LibraryRolesDto;
import com.imcode.imcms.addon.imagearchive.entity.LibraryRoles;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRolesRepository;
import com.imcode.imcms.addon.imagearchive.service.LibraryRolesService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author Serhii from Ubrainians for Imcode
 *         10.10.16
 */
@Service
public class LibraryRolesServiceImpl implements LibraryRolesService {

    @Autowired
    private LibraryRolesRepository libraryRolesRepository;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Collection<LibraryRoles> findLibraryRolesByLibraryId(long id) {
        return libraryRolesRepository.findByLibraryId(id);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Collection<LibraryRolesDto> findLibraryRolesDtoByLibraryId(long id) {
        return convertToLibraryRolesDto(findLibraryRolesByLibraryId(id));
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public void delete(LibraryRoles libraryRoles) {
        libraryRolesRepository.delete(libraryRoles);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public void delete(Iterable<LibraryRoles> libraryRoles) {
        libraryRolesRepository.delete(libraryRoles);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Collection<LibraryRoles> findAll() {
        return libraryRolesRepository.findAll();
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public void updateLibraryRoles(long libraryId, String libraryNm, Collection<LibraryRolesDto> oldAndNewLibraryRoles) {
        List<LibraryRolesDto> existingLibraryRoles = convertToLibraryRolesDto(libraryRolesRepository.findByLibraryId(libraryId));
        Collection<LibraryRolesDto> newLibraryRoles = CollectionUtils.subtract(oldAndNewLibraryRoles, existingLibraryRoles);
        List<LibraryRoles> libraryRoles = convertToLibraryRoles(libraryId, newLibraryRoles);

        libraryRolesRepository.save(libraryRoles);
    }

    private List<LibraryRolesDto> convertToLibraryRolesDto(Collection<LibraryRoles> libraries) {
        List<LibraryRolesDto> libraryRolesDtos = new ArrayList<LibraryRolesDto>();

        for (LibraryRoles library : libraries) {
            libraryRolesDtos.add(convertToLibraryRolesDto(library));
        }

        return libraryRolesDtos;
    }

    private LibraryRolesDto convertToLibraryRolesDto(LibraryRoles library) {
        if (library == null) {
            return null;
        }

        LibraryRolesDto librariesDto = new LibraryRolesDto();
        librariesDto.setPermissions(library.getPermissions());
        librariesDto.setRoleId(library.getRoleId());
        librariesDto.setCanUse(library.getCanUse());
        librariesDto.setCanChange(library.getCanChange());
        return librariesDto;
    }

    private List<LibraryRoles> convertToLibraryRoles(long libraryId,
                                                     Collection<LibraryRolesDto> libraryRolesDtoCollection) {
        List<LibraryRoles> libraryRolesDtos = new ArrayList<LibraryRoles>();

        for (LibraryRolesDto libraryRolesDto : libraryRolesDtoCollection) {
            libraryRolesDtos.add(convertToLibraryRoles(libraryId, libraryRolesDto));
        }

        return libraryRolesDtos;
    }

    private LibraryRoles convertToLibraryRoles(long libraryId, LibraryRolesDto libraryRolesDto) {
        if (libraryRolesDto == null) {
            return null;
        }

        LibraryRoles libraryRoles = new LibraryRoles();
        libraryRoles.setLibraryId(libraryId);
        libraryRoles.setRoleId(libraryRolesDto.getRoleId());
        libraryRoles.setPermissions(libraryRolesDto.getPermissions());
        libraryRoles.setCanUse(libraryRolesDto.isCanUse());
        libraryRoles.setCanChange(libraryRolesDto.isCanChange());
        return libraryRoles;
    }
}
