/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.entity.LibraryRoles;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.filter.SubDirectoriesFileFilter;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRepository;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.LibraryService;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LibraryServiceImpl
implements LibraryService {
    private static final Log log = LogFactory.getLog(LibraryServiceImpl.class);
    @Autowired
    private Facade facade;
    @Autowired
    private LibraryRepository libraryRepository;

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Library findLibraryById(Long libraryId) {
        return (Library)this.libraryRepository.findOne(libraryId);
    }

    @Deprecated
    public void syncLibraryFolders() {
        this.syncOldLibraryFolders((short)1);
        this.syncOldLibraryFolders((short)0);
    }

    @Deprecated
    private void syncOldLibraryFolders(short typeOldLibrary) {
        String folderNm;
        Object[] oldLibraryFiles = this.facade.getConfig().getImcmsOldLibraryPaths();
        HashSet files = new HashSet();
        for (File file : oldLibraryFiles) {
            List tmp = this.facade.getFileService().getSubdirs(file, (FileFilter)new SubDirectoriesFileFilter());
            files.addAll(tmp);
        }
        CollectionUtils.addAll(files, (Object[])oldLibraryFiles);
        if (files.isEmpty()) {
            this.libraryRepository.deleteByLibraryType(typeOldLibrary);
        }
        List<Library> existingLibraries = this.libraryRepository.findByLibraryType(typeOldLibrary);
        LinkedList<Library> toDelete = new LinkedList<Library>();
        for (Library library : existingLibraries) {
            folderNm = library.getFolderNm();
            String filepath = library.getFilepath();
            File file = new File(filepath, folderNm);
            if (!files.contains(file)) {
                toDelete.add(library);
                continue;
            }
            files.remove(file);
        }
        if (!toDelete.isEmpty()) {
            for (Library library : toDelete) {
                try {
                    Collection libraryRoles = this.facade.getLibraryRolesService().findLibraryRolesByLibraryId(library.getId().longValue());
                    this.facade.getLibraryRolesService().delete((Iterable)libraryRoles);
                    this.libraryRepository.delete(library);
                }
                catch (Exception e) {
                    log.error((Object)String.format(new Date() + ": Error deleting library %s", library.toString()), (Throwable)e);
                }
            }
        }
        for (File file : files) {
            String filePath;
            folderNm = file.getName();
            if (this.libraryRepository.findByFolderNameAndFilePath(folderNm, filePath = StringUtils.substring((String)folderNm, (int)0, (int)120)) == null) continue;
            Library lib = new Library();
            lib.setFolderNm(folderNm);
            lib.setLibraryNm(filePath);
            lib.setFilepath(file.getParent());
            lib.setLibraryType(typeOldLibrary);
            try {
                this.libraryRepository.save(lib);
            }
            catch (Exception e) {
                log.error((Object)String.format(new Date() + ": Library already exist,  %s", lib.toString()), (Throwable)e);
            }
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Library> getAllLibraries() {
        return this.libraryRepository.findAll();
    }

    public List<LibrariesDto> librariesToDto(List<Library> libraries) {
        LinkedList<LibrariesDto> librariesDtos = new LinkedList<LibrariesDto>();
        for (Library library : libraries) {
            LibrariesDto librariesDto = this.convertToLibraryDto(library);
            librariesDtos.add(librariesDto);
        }
        return librariesDtos;
    }

    public LibrariesDto convertToLibraryDto(Library library) {
        LibrariesDto librariesDto = new LibrariesDto();
        librariesDto.setId(library.getId());
        librariesDto.setLibraryNm(library.getLibraryNm());
        librariesDto.setFilepath(library.getFilepath());
        librariesDto.setFolderNm(library.getFolderNm());
        return librariesDto;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public LibrariesDto findLibraryDtoById(Long id) {
        return this.convertToLibraryDto((Library)this.libraryRepository.findOne(id));
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<LibrariesDto> findLibraryDtos() {
        return this.librariesToDto(this.libraryRepository.findAll());
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Collection<Role> getAllRoles() {
        Collection allLibraryRoles = this.facade.getLibraryRolesService().findAll();
        ArrayList<Integer> allLibraryRolesIds = new ArrayList<Integer>();
        for (LibraryRoles libraryRole : allLibraryRoles) {
            allLibraryRolesIds.add(libraryRole.getRoleId());
        }
        Collection roles = this.facade.getRoleService().getRoleById(allLibraryRolesIds);
        return roles;
    }
}

