/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.dto.LibraryRolesDto;
import com.imcode.imcms.addon.imagearchive.entity.LibraryRoles;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRolesRepository;
import com.imcode.imcms.addon.imagearchive.service.LibraryRolesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LibraryRolesServiceImpl
implements LibraryRolesService {
    @Autowired
    private LibraryRolesRepository libraryRolesRepository;

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Collection<LibraryRoles> findLibraryRolesByLibraryId(long id) {
        return this.libraryRolesRepository.findByLibraryId(id);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Collection<LibraryRolesDto> findLibraryRolesDtoByLibraryId(long id) {
        return this.convertToLibraryRolesDto(this.findLibraryRolesByLibraryId(id));
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void delete(LibraryRoles libraryRoles) {
        this.libraryRolesRepository.delete((Object)libraryRoles);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void delete(Iterable<LibraryRoles> libraryRoles) {
        this.libraryRolesRepository.delete(libraryRoles);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Collection<LibraryRoles> findAll() {
        return this.libraryRolesRepository.findAll();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void updateLibraryRoles(long libraryId, String libraryNm, Collection<LibraryRolesDto> oldAndNewLibraryRoles) {
        List<LibraryRolesDto> existingLibraryRoles = this.convertToLibraryRolesDto(this.libraryRolesRepository.findByLibraryId(libraryId));
        Collection newLibraryRoles = CollectionUtils.subtract(oldAndNewLibraryRoles, existingLibraryRoles);
        List<LibraryRoles> libraryRoles = this.convertToLibraryRoles(libraryId, newLibraryRoles);
        this.libraryRolesRepository.save(libraryRoles);
    }

    private List<LibraryRolesDto> convertToLibraryRolesDto(Collection<LibraryRoles> libraries) {
        ArrayList<LibraryRolesDto> libraryRolesDtos = new ArrayList<LibraryRolesDto>();
        for (LibraryRoles library : libraries) {
            libraryRolesDtos.add(this.convertToLibraryRolesDto(library));
        }
        return libraryRolesDtos;
    }

    private LibraryRolesDto convertToLibraryRolesDto(LibraryRoles library) {
        if (library == null) {
            return null;
        }
        LibraryRolesDto librariesDto = new LibraryRolesDto();
        librariesDto.setPermissions(library.getPermissions());
        librariesDto.setRoleId(library.getRoleId());
        librariesDto.setCanUse(library.getCanUse().booleanValue());
        librariesDto.setCanChange(library.getCanChange().booleanValue());
        return librariesDto;
    }

    private List<LibraryRoles> convertToLibraryRoles(long libraryId, Collection<LibraryRolesDto> libraryRolesDtoCollection) {
        ArrayList<LibraryRoles> libraryRolesDtos = new ArrayList<LibraryRoles>();
        for (LibraryRolesDto libraryRolesDto : libraryRolesDtoCollection) {
            libraryRolesDtos.add(this.convertToLibraryRoles(libraryId, libraryRolesDto));
        }
        return libraryRolesDtos;
    }

    private LibraryRoles convertToLibraryRoles(long libraryId, LibraryRolesDto libraryRolesDto) {
        if (libraryRolesDto == null) {
            return null;
        }
        LibraryRoles libraryRoles = new LibraryRoles();
        libraryRoles.setLibraryId(libraryId);
        libraryRoles.setRoleId(libraryRolesDto.getRoleId());
        libraryRoles.setPermissions(libraryRolesDto.getPermissions());
        libraryRoles.setCanUse(Boolean.valueOf(libraryRolesDto.isCanUse()));
        libraryRoles.setCanChange(Boolean.valueOf(libraryRolesDto.isCanChange()));
        return libraryRoles;
    }
}

