package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.entity.LibraryRoles;
import com.imcode.imcms.addon.imagearchive.repository.LibraryRolesRepository;
import com.imcode.imcms.addon.imagearchive.service.LibraryRolesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;

/**
 * @author Serhii from Ubrainians for Imcode
 *         10.10.16
 */
@Service
public class LibraryRolesServiceImpl implements LibraryRolesService {

    @Autowired
    private LibraryRolesRepository libraryRolesRepository;

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public LibraryRoles getLibraryRolesById(int id) {
        return libraryRolesRepository.findOne(id);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public void delete(LibraryRoles libraryRoles) {
        libraryRolesRepository.delete(libraryRoles);
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public Collection<LibraryRoles> getAll() {
        return libraryRolesRepository.findAll();
    }
}
