CREATE TABLE category
(
    category_id INT PRIMARY KEY NOT NULL AUTO_INCREMENT,
    category_type_id INT NOT NULL,
    name VARCHAR(128) NOT NULL,
    description VARCHAR(500),
    image VARCHAR(255) NOT NULL,
    FOREIGN KEY (category_type_id) REFERENCES category_types (category_type_id)
);
CREATE INDEX fk__categories__category_types ON category (category_type_id);
CREATE TABLE category_type
(
    category_type_id INT PRIMARY KEY NOT NULL AUTO_INCREMENT,
    name VARCHAR(128) NOT NULL,
    max_choices INT DEFAULT 0 NOT NULL,
    inherited TINYINT NOT NULL,
    is_image_archive TINYINT DEFAULT 0 NOT NULL
);
CREATE TABLE exif
(
    image_id BIGINT NOT NULL,
    exif_type SMALLINT DEFAULT 0 NOT NULL,
    x_resolution INT,
    y_resolution INT,
    description VARCHAR(255) DEFAULT '' NOT NULL,
    artist VARCHAR(255) DEFAULT '' NOT NULL,
    copyright VARCHAR(255) DEFAULT '' NOT NULL,
    created_dt TIMESTAMP DEFAULT '0000-00-00 00:00:00' NOT NULL,
    updated_dt TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    exposure DOUBLE,
    pixel_y_dimension INT,
    manufacturer VARCHAR(255),
    model VARCHAR(255),
    compression VARCHAR(255),
    exposure_program VARCHAR(255),
    fstop REAL,
    flash INT,
    focal_length REAL,
    color_space VARCHAR(255),
    resolution_unit SMALLINT,
    pixel_x_dimension INT,
    date_original TIMESTAMP,
    date_digitized TIMESTAMP,
    ISO INT,
    PRIMARY KEY (image_id, exif_type),
    FOREIGN KEY (image_id) REFERENCES archive_images (id)
);
CREATE TABLE image
(
    id BIGINT PRIMARY KEY NOT NULL AUTO_INCREMENT,
    image_nm VARCHAR(255) DEFAULT '' NOT NULL,
    format SMALLINT NOT NULL,
    width INT NOT NULL,
    height INT NOT NULL,
    file_size INT NOT NULL,
    uploaded_by VARCHAR(130) DEFAULT '' NOT NULL,
    status SMALLINT DEFAULT 0 NOT NULL,
    created_dt TIMESTAMP DEFAULT '0000-00-00 00:00:00' NOT NULL,
    updated_dt TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    license_dt DATE,
    license_end_dt DATE,
    alt_text VARCHAR(125)
);
CREATE TABLE image_categories
(
    image_id BIGINT NOT NULL,
    category_id INT NOT NULL,
    created_dt TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (image_id, category_id),
    FOREIGN KEY (image_id) REFERENCES archive_images (id)
);
CREATE INDEX image_categories_category_id_fk ON image_categories (category_id);
CREATE TABLE image_keywords
(
    image_id BIGINT NOT NULL,
    keyword_id BIGINT NOT NULL,
    created_dt TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (image_id, keyword_id),
    FOREIGN KEY (image_id) REFERENCES archive_images (id),
    FOREIGN KEY (keyword_id) REFERENCES archive_keywords (id)
);
CREATE INDEX archive_image_keywords_keyword_id_fk ON image_keywords (keyword_id);
CREATE TABLE keyword
(
    id BIGINT PRIMARY KEY NOT NULL AUTO_INCREMENT,
    keyword_nm VARCHAR(50) DEFAULT '' NOT NULL,
    created_dt TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL
);
CREATE TABLE library
(
    id INT PRIMARY KEY NOT NULL AUTO_INCREMENT,
    library_nm VARCHAR(120) NOT NULL,
    folder_nm VARCHAR(255) NOT NULL,
    filepath VARCHAR(255),
    library_type SMALLINT DEFAULT 0 NOT NULL,
    created_dt TIMESTAMP DEFAULT '0000-00-00 00:00:00' NOT NULL,
    updated_dt TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL
);
CREATE UNIQUE INDEX archive_libraries_folder_nm_filepath_unq ON library (folder_nm, filepath);
CREATE TABLE library_roles
(
    library_id INT NOT NULL,
    role_id INT NOT NULL,
    permissions INT NOT NULL,
    created_dt TIMESTAMP DEFAULT '0000-00-00 00:00:00' NOT NULL,
    updated_dt TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    canUse TINYINT NOT NULL,
    canChange TINYINT NOT NULL,
    PRIMARY KEY (library_id, role_id),
    FOREIGN KEY (library_id) REFERENCES libraries (id),
    FOREIGN KEY (role_id) REFERENCES role (role_id)
);
CREATE INDEX archive_library_roles_role_id_fk ON library_roles (role_id);
CREATE TABLE roles
(
    role_id INT PRIMARY KEY NOT NULL AUTO_INCREMENT,
    role_name VARCHAR(60) NOT NULL,
    permissions INT DEFAULT 0 NOT NULL,
    admin_role INT DEFAULT 0 NOT NULL
);
CREATE UNIQUE INDEX uk__roles__role_name ON role (role_name);
