/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.util;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientUtils {
    private static final Log log = LogFactory.getLog(ClientUtils.class);
    private static Facade facade;

    private ClientUtils() {
    }

    private static Facade getFacade() {
        if (facade == null) {
            facade = Utils.getFacade();
        }
        return facade;
    }

    public static User getLoggedInUser(HttpServletRequest request) {
        Long userId;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        User user = ClientUtils.getUserFromSession(session);
        if (ClientUtils.shouldUserBeFounded(user, userId = ClientUtils.getUserIdFromRequest((ServletRequest)request)) && ClientUtils.isUserLoggedIn(user = ClientUtils.getFacade().getUserService().findUserById(userId.longValue()))) {
            ClientUtils.saveUserToSession(session, user);
        }
        return ClientUtils.isUserLoggedIn(user) ? user : null;
    }

    private static Long getUserIdFromRequest(ServletRequest request) {
        BeanMap introspected;
        Object cms = request.getAttribute("com.imcode.imcms.ImcmsSystem");
        Long userId = null;
        if (cms != null && (introspected = new BeanMap(cms)).containsKey((Object)"currentUser")) {
            BeanMap objectUser = new BeanMap(introspected.get((Object)"currentUser"));
            userId = Long.valueOf(ObjectUtils.toString((Object)objectUser.get((Object)"id"), (String)"2"));
        }
        return userId;
    }

    private static boolean shouldUserBeFounded(User user, Long userId) {
        return userId != null && (user == null || userId.compareTo(user.getId()) != 0);
    }

    private static void saveUserToSession(HttpSession session, User user) {
        session.setAttribute("user", (Object)user);
    }

    public static User getUserFromSession(HttpSession session) {
        return (User)session.getAttribute("user");
    }

    public static String getImcmsReturnToUrl(HttpSession session) {
        return (String)session.getAttribute("returnToImcms");
    }

    public static boolean isUserNotLoggedIn(HttpServletRequest request) {
        User user = ClientUtils.getLoggedInUser(request);
        return ClientUtils.isUserNotLoggedIn(user);
    }

    public static boolean isUserNotLoggedIn(User user) {
        return user == null || user.isDefault();
    }

    public static boolean isUserLoggedIn(User user) {
        return !ClientUtils.isUserNotLoggedIn(user);
    }

    public static void redirectToLogin(HttpServletResponse response) {
        try {
            Config config = ClientUtils.getFacade().getConfig();
            response.sendRedirect(config.getImcmsRootUrl() + "/" + config.getImcmsLoginUrlPath());
        }
        catch (IOException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static List<Image> isInArchive(File img) {
        ArrayList<Image> sameImages = new ArrayList<Image>();
        List archiveImages = ClientUtils.getFacade().getImageService().getAllImages();
        for (Image image : archiveImages) {
            if (img == null || !image.getName().equals(img.getName()) || (long)image.getFileSize() != img.length()) continue;
            sameImages.add(image);
        }
        return sameImages;
    }

    public static Collection<Category> getCategoriesRequiredToUse(Image img) {
        Facade localFacade = ClientUtils.getFacade();
        List userCategories = localFacade.getCategoryService().getCategories();
        List imageCategories = localFacade.getCategoryService().getCategories(img);
        Collection<Object> categoriesUserCantUse = Collections.emptyList();
        if (imageCategories != null) {
            categoriesUserCantUse = CollectionUtils.subtract((Iterable)imageCategories, (Iterable)userCategories);
        }
        return categoriesUserCantUse;
    }

    public static boolean canAccessPreferences(User user) {
        return user.isSuperadmin() || ClientUtils.isImageAdmin(user);
    }

    public static boolean isImageAdmin(User user) {
        Role role = ClientUtils.getFacade().getRoleService().getRoleByName("Bildadmin");
        return role != null && user.hasRole(role);
    }

    public static boolean canUseOrChangeImage(Image image, User user) {
        return ClientUtils.canChangeImage(image, user) || ClientUtils.canUseImage(image, user);
    }

    public static boolean canUseImage(Image image, User user) {
        return user.isSuperadmin() || ClientUtils.isImageAdmin(user) || image.getCategories().size() == 0 || ClientUtils.isImageOfUsableRoleCategories(image, user);
    }

    private static boolean isImageOfUsableRoleCategories(Image image, User user) {
        List usableRoleCategories = ClientUtils.getFacade().getRoleService().getUsableRoleCategories(user.getRoles().toArray(new Role[0]));
        return ClientUtils.hasImageNextCategories(image, usableRoleCategories);
    }

    private static boolean hasImageNextCategories(Image image, List<Category> categories) {
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        for (Category category : categories) {
            categoryIds.add(category.getId());
        }
        List imageCategories = image.getCategories();
        return CollectionUtils.containsAny(categoryIds, (Collection)imageCategories);
    }

    public static boolean canChangeImage(Image image, User user) {
        boolean canChangeImage = user.isSuperadmin() || ClientUtils.isImageAdmin(user) || image.getCategories().size() == 0 || ClientUtils.isImageOfChangeableRoleCategories(image, user);
        image.setCanChange(canChangeImage);
        return image.isCanChange();
    }

    private static boolean isImageOfChangeableRoleCategories(Image image, User user) {
        List usableRoleCategories = ClientUtils.getFacade().getRoleService().getChangeableRoleCategories(user.getRoles().toArray(new Role[0]));
        return ClientUtils.hasImageNextCategories(image, usableRoleCategories);
    }
}

