/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryType;
import com.imcode.imcms.addon.imagearchive.repository.CategoryTypeRepository;
import com.imcode.imcms.addon.imagearchive.service.CategoryTypeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CategoryTypeServiceImpl
implements CategoryTypeService {
    @Autowired
    private CategoryTypeRepository categoryTypeRepository;

    @Transactional
    public Collection<CategoryType> getCategoryTypes() {
        return this.categoryTypeRepository.findAll();
    }

    @Transactional
    public Collection<Category> getCategoriesOfTypes(Collection<CategoryType> categoryTypes) {
        ArrayList<Category> result = new ArrayList<Category>();
        for (CategoryType categoryType : categoryTypes) {
            Collection<Category> categoriesOfType = this.getCategoriesOfType(categoryType);
            result.addAll(categoriesOfType);
        }
        return result;
    }

    @Transactional
    public Collection<Category> getCategoriesOfType(CategoryType categoryType) {
        return this.getCategoriesOfType(categoryType.getId());
    }

    @Transactional
    public Collection<Category> getCategoriesOfType(Integer id) {
        CategoryType categoryType = (CategoryType)this.categoryTypeRepository.findOne((Serializable)id);
        return categoryType.getCategories();
    }

    @Transactional
    public Collection<Long> getCategoryIdsOfTypes(Collection<CategoryType> categoryTypes) {
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        Collection<Category> categoriesOfTypes = this.getCategoriesOfTypes(categoryTypes);
        for (Category categoriesOfType : categoriesOfTypes) {
            Long id = categoriesOfType.getId();
            categoryIds.add(id);
        }
        return categoryIds;
    }
}

