/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.util;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUtils {
    private static final Log log = LogFactory.getLog(ClientUtils.class);

    public static User getLoggedInUser(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        User user = ClientUtils.getUserFromSession(session);
        Long userId = ClientUtils.getUserIdFromCMS((ServletRequest)request);
        if (user == null && userId != null) {
            user = Utils.getFacade().getUserService().findUserById(userId.longValue());
            ClientUtils.setUserToSession(session, user);
        }
        return ClientUtils.userNotLoggedIn(user) ? null : user;
    }

    private static Long getUserIdFromCMS(ServletRequest request) {
        BeanMap introspected;
        Object cms = request.getAttribute("com.imcode.imcms.ImcmsSystem");
        Long userId = null;
        if (cms != null && (introspected = new BeanMap(cms)).containsKey((Object)"currentUser")) {
            BeanMap objectUser = new BeanMap(introspected.get((Object)"currentUser"));
            userId = Long.valueOf(ObjectUtils.toString((Object)objectUser.get((Object)"id"), (String)"2"));
        }
        return userId;
    }

    public static void setUserToSession(HttpSession session, User user) {
        session.setAttribute("user", (Object)user);
    }

    public static User getUserFromSession(HttpSession session) {
        return (User)session.getAttribute("user");
    }

    public static String getImcmsReturnToUrl(HttpSession session) {
        return (String)session.getAttribute("returnToImcms");
    }

    public static boolean userNotLoggedIn(HttpServletRequest request) {
        User user = ClientUtils.getLoggedInUser(request);
        return ClientUtils.userNotLoggedIn(user);
    }

    public static boolean userNotLoggedIn(User user) {
        return user == null || user.isDefault();
    }

    public static void redirectToLogin(HttpServletResponse response) {
        try {
            Config config = Utils.getFacade().getConfig();
            response.sendRedirect(config.getImcmsRootUrl() + "/" + config.getImcmsLoginUrlPath());
        }
        catch (IOException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static List<Image> isInArchive(File img, Facade facade) {
        ArrayList<Image> sameImages = new ArrayList<Image>();
        List archiveImages = facade.getImageService().getAllImages();
        for (Image image : archiveImages) {
            if (img == null || !image.getName().equals(img.getName()) || (long)image.getFileSize() != img.length()) continue;
            sameImages.add(image);
        }
        return sameImages;
    }

    public static Collection<Category> getCategoriesRequiredToUse(Image img, Facade facader) {
        List userCategories = facader.getCategoryService().getCategories();
        List imageCategories = img.getCategories();
        Collection<Object> categoriesUserCantUse = Collections.emptyList();
        if (imageCategories != null) {
            categoriesUserCantUse = CollectionUtils.subtract((Iterable)imageCategories, (Iterable)userCategories);
        }
        return categoriesUserCantUse;
    }

    public static boolean canAccessPreferences(User user, Facade facade) {
        return user.isSuperadmin() || ClientUtils.isImageAdmin(user, facade);
    }

    public static boolean isImageAdmin(User user, Facade facade) {
        Role role = facade.getRoleService().getRoleByName("Bildadmin");
        return role != null && user.hasRole(role);
    }

    private ClientUtils() {
    }

    public static boolean canUseOrChangeImage(Image image, User user, Facade facade) {
        return ClientUtils.canChangeImage(image, user, facade) || ClientUtils.canUseImage(image, user, facade);
    }

    public static boolean canUseImage(Image image, User user, Facade facade) {
        return user.isSuperadmin() || ClientUtils.isImageAdmin(user, facade) || image.getCategories().size() == 0 || CollectionUtils.containsAny((Collection)facade.getRoleService().getUsableRoleCategories(user.getRoles().toArray(new Role[0])), (Collection)image.getCategories());
    }

    public static boolean canChangeImage(Image image, User user, Facade facade) {
        image.setCanChange(user.isSuperadmin() || ClientUtils.isImageAdmin(user, facade) || image.getCategories().size() == 0 || CollectionUtils.containsAny((Collection)facade.getRoleService().getChangeableRoleCategories(user.getRoles().toArray(new Role[0])), (Collection)image.getCategories()));
        return image.isCanChange();
    }
}

