package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.filter.SessionListener;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * Tries to restore previous session for user
 *
 * @author Serhii from Ubrainians for Imcode
 * @since 1.0.2
 */
@Controller
public class RestoreSessionController {

    /**
     * Redirect user to last document that was get from session history by
     * {@link SessionListener}
     */
    @RequestMapping("/restore")
    public String restore(HttpServletRequest request) throws IOException, ServletException {

        User user = ClientUtils.getLoggedInUser(request);
        Integer lastDoc = 1001;

        if (user != null) {
            long userId = user.getId();
            Integer docFromHistory = SessionListener.getLastDocumentFor(userId);

            if (docFromHistory != null) {
                lastDoc = docFromHistory;
            }
        }

        return "redirect:" + Utils.getFacade().getConfig().getImcmsRootUrl() + "/" + lastDoc;
    }
}
