package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.filter.SessionListener;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Tries to restore previous session for user
 *
 * @author Serhii from Ubrainians for Imcode
 * @since 1.0.2
 */
@Controller
public class RestoreSessionController {

    /**
     * Redirect user to last document that was get from session history by
     * {@link SessionListener}
     */
    @RequestMapping("/restore")
    public void restore(HttpServletRequest request,
                        HttpServletResponse response) throws IOException, ServletException {

        User user = ClientUtils.getLoggedInUser(request);

        if (user != null) {
            long userId = user.getId();
            Integer lastDoc = SessionListener.getLastDocumentFor(userId);

            if (lastDoc != null) {
                response.sendRedirect(request.getContextPath() + "/" + lastDoc);
            }
        }
    }
}
