package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
import com.imcode.imcms.addon.imagearchive.entity.User;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/**
 * Session listener, holds returnTo parameter after session timeout
 * <p>
 * Created by Serhii from Ubrainians for Imcode
 * on 19.09.16.
 */
public class SessionListener implements HttpSessionListener {

    private static Map<Long, Integer> usersToPages = new WeakHashMap<Long, Integer>();

    // Public constructor is required by servlet spec
    public SessionListener() {
    }

    public static Integer getLastDocumentFor(long userId) {
        return usersToPages.get(userId);
    }

    public void sessionCreated(HttpSessionEvent event) {
        // do nothing
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        final HttpSession session = event.getSession();
        final User user = (User) session.getAttribute(SessionConstants.USER);

        if (user != null) {
            Long userId = user.getId();

            Integer lastDocument = 1001; // start doc as default
            @SuppressWarnings("unchecked")
            final List<Integer> history =  (List<Integer>) session.getAttribute("history");

            if ((history != null) && (history.size() > 0)) {
                lastDocument = history.get(history.size() - 1);
            }

            usersToPages.put(userId, lastDocument);
        }
    }

    public static void removeUser(Long userId) {
        usersToPages.remove(userId);
    }
}
