package com.imcode.imcms.addon.imagearchive.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class UTF8RequestWrapper extends HttpServletRequestWrapper {
    private Map<String, String[]> paramMap;
    
    public UTF8RequestWrapper(HttpServletRequest request) {
        super(request);
    }
    
    @Override
    public String getParameter(String name) {
        String param = super.getParameter(name);
        
        if (param == null) {
            return param;
        }
        
        return toUTF8(param);
    }
    
    @Override
    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        
        if (values == null) {
            return null;
        }
        
        for (int i = 0; i < values.length; i++) {
            values[i] = toUTF8(values[i]);
        }
        
        return values;
    }
    
    @Override
    public Map getParameterMap() {
        if (paramMap != null) {
            return paramMap;
        }
        
        Map<String, String[]> origParamMap = super.getParameterMap();
        paramMap = new HashMap<String, String[]>(origParamMap.size());
        
        for (Entry<String, String[]> entry : origParamMap.entrySet()) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            
            if (values != null) {
                for (int i = 0; i < values.length; i++) {
                    values[i] = toUTF8(values[i]);
                }
            }
            
            paramMap.put(name, values);
        }
        
        return paramMap;
    }
    
    private static String toUTF8(String value) {
        if (value == null) {
            return null;
        }
        
        try {
            return new String(value.getBytes("ISO-8859-1"), "UTF-8");
        } catch (Exception ex) {
            return value;
        }
    }
}
