package com.imcode.imcms.addon.imagearchive.entity;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Table(name = "categories")
public class ClientCategory implements Serializable, Comparable<ClientCategory> {
    private static final long serialVersionUID = 7533187253952781894L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "category_id", insertable=true, updatable=true, unique=true, nullable = false)
    private Long id;

    @Column(name = "category_type_id", nullable = false)
    private Long categoryTypeId;

    @Column(name = "name", length = 128, nullable = false)
    private String name;

    @Column(name = "description", length = 500)
    private String description;

    @Column(name="image", nullable = false)
    private String image;

    public ClientCategory() {
    }

    public ClientCategory(String name, Long typeId) {
        this.name = name;
        this.categoryTypeId = typeId;
        this.image = "";
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

//    public CategoryTypes getType() {
//        return type;
//    }
//
//    public void setType(CategoryTypes type) {
//        this.type = type;
//    }
//
//    public int getTypeId() {
//        return typeId;
//    }
//
//    public void setTypeId(int typeId) {
//        this.typeId = typeId;
//    }
//

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        final ClientCategory other = (ClientCategory) obj;

        return this.id.equals(other.id);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = (int) (97 * hash + this.id);

        return hash;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.ClientCategory[id: %d, name: %s]",
                id, name);
    }

    public int compareTo(ClientCategory o) {
        return this.id.compareTo(o.getId());
    }

    public Long getCategoryTypeId() {
        return categoryTypeId;
    }

    public void setCategoryTypeId(Long categoryTypeId) {
        this.categoryTypeId = categoryTypeId;
    }
}
