/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.entity.ClientCategory;
import com.imcode.imcms.addon.imagearchive.repository.ClientCategoryRepository;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;
import com.imcode.imcms.addon.imagearchive.service.impl.ClientCategoryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class ClientCategoryServiceImpl
implements ClientCategoryService {
    @Autowired
    private ClientCategoryRepository repository;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean existsCategory(String categoryName) {
        return this.repository.findByName(categoryName) != null;
    }

    @Override
    public ClientCategory createCategory(String categoryName, Long typeId) throws CategoryExistsException {
        if (this.repository.findByName(categoryName) != null) {
            throw new CategoryExistsException();
        }
        ClientCategory category = new ClientCategory(categoryName, typeId);
        return (ClientCategory)this.repository.save(category);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public ClientCategory getCategory(Long categoryId) {
        return (ClientCategory)this.repository.findOne(categoryId);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<ClientCategory> getCategories() {
        return this.repository.findAll();
    }

    @Override
    public void deleteCategory(Long categoryId) {
        this.repository.delete(categoryId);
    }

    @Override
    public void updateCategory(Long categoryId, String categoryName) throws CategoryExistsException {
        ClientCategory existsCategory = (ClientCategory)this.repository.findOne(categoryId);
        if (existsCategory != null && this.repository.findByName(categoryName) == null) {
            existsCategory.setName(categoryName);
            this.repository.save(existsCategory);
        }
    }

    @Override
    public ClientCategory getCategory(String name) {
        return this.repository.findByName(name);
    }
}

