package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;

import javax.servlet.ServletException;
import javax.servlet.http.*;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/**
 * Session listener, holds returnTo parameter after session timeout
 * <p>
 * Created by Serhii from Ubrainians for Imcode
 * on 19.09.16.
 */
public class SessionListener implements HttpSessionListener {

    private static Map<Long, UserPagesKeeper> usersToPages = new WeakHashMap<Long, UserPagesKeeper>();

    // Public constructor is required by servlet spec
    public SessionListener() {
    }

    public static Integer getLastDocumentFor(long userId) {
        final UserPagesKeeper userPagesKeeper = usersToPages.get(userId);

        if (userPagesKeeper != null) {
            return userPagesKeeper.getLastDocument();
        }

        return null;
    }

    public static String getReturnToFor(long userId) {
        final UserPagesKeeper userPagesKeeper = usersToPages.get(userId);

        if (userPagesKeeper != null) {
            return userPagesKeeper.getReturnTo();
        }

        return null;
    }

    public void sessionCreated(HttpSessionEvent event) {
        // do nothing
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        final HttpSession session = event.getSession();
        final User user = (User) session.getAttribute(SessionConstants.USER);

        if (user != null) {
            Long userId = user.getId();

            String returnTo = ClientUtils.getImcmsReturnToUrl(session);
            // something like "http://skurup.dev.imcode.com/servlet/PageDispatcher?page=j1x503GhYi&image_archive=yes&"
            Integer lastDocument = null;
            @SuppressWarnings("unchecked")
            final List<Integer> history =  (List<Integer>) session.getAttribute("history");

            if ((history != null) && (history.size() > 0)) {
                lastDocument = history.get(history.size() - 1);
            }

            usersToPages.put(userId, new UserPagesKeeper(returnTo, lastDocument)); // put only returnTo for now
        }
    }

    private class UserPagesKeeper {
        private String returnTo;
        private Integer lastDocument;

        UserPagesKeeper(String returnTo, Integer lastDocument) {
            this.returnTo = returnTo;
            this.lastDocument = lastDocument;
        }

        public String getReturnTo() {
            return returnTo;
        }

        public void setReturnTo(String returnTo) {
            this.returnTo = returnTo;
        }

        public Integer getLastDocument() {
            return lastDocument;
        }

        public void setLastDocument(Integer lastDocument) {
            this.lastDocument = lastDocument;
        }
    }
}
