/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionListener
implements HttpSessionListener {
    private static Map<Long, UserPagesKeeper> usersToPages = new WeakHashMap<Long, UserPagesKeeper>();

    public static Integer getLastDocumentFor(long userId) {
        UserPagesKeeper userPagesKeeper = usersToPages.get(userId);
        if (userPagesKeeper != null) {
            return userPagesKeeper.getLastDocument();
        }
        return null;
    }

    public static String getReturnToFor(long userId) {
        UserPagesKeeper userPagesKeeper = usersToPages.get(userId);
        if (userPagesKeeper != null) {
            return userPagesKeeper.getReturnTo();
        }
        return null;
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        User user = (User)session.getAttribute("user");
        if (user != null) {
            Long userId = user.getId();
            String returnTo = ClientUtils.getImcmsReturnToUrl(session);
            Integer lastDocument = null;
            List history = (List)session.getAttribute("history");
            if (history != null && history.size() > 0) {
                lastDocument = (Integer)history.get(history.size() - 1);
            }
            usersToPages.put(userId, new UserPagesKeeper(returnTo, lastDocument));
        }
    }

    private class UserPagesKeeper {
        private String returnTo;
        private Integer lastDocument;

        UserPagesKeeper(String returnTo, Integer lastDocument) {
            this.returnTo = returnTo;
            this.lastDocument = lastDocument;
        }

        public String getReturnTo() {
            return this.returnTo;
        }

        public void setReturnTo(String returnTo) {
            this.returnTo = returnTo;
        }

        public Integer getLastDocument() {
            return this.lastDocument;
        }

        public void setLastDocument(Integer lastDocument) {
            this.lastDocument = lastDocument;
        }
    }
}

