package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import org.apache.commons.beanutils.BeanMap;

import javax.servlet.ServletException;
import javax.servlet.http.*;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;

/**
 * Session listener, holds returnTo parameter after session timeout
 * <p>
 * Created by Serhii from Ubrainians for Imcode
 * on 19.09.16.
 */
public class SessionListener implements HttpSessionListener {

    private static Map<Long, UserPagesKeeper> usersToPages = new WeakHashMap<Long, UserPagesKeeper>();

    // Public constructor is required by servlet spec
    public SessionListener() {
    }

    public static DispatchCommand getCancelCommandFor(long userId) {
        final UserPagesKeeper userPagesKeeper = usersToPages.get(userId);

        if (userPagesKeeper != null) {
            return userPagesKeeper.getCancelCommand();
        }

        return null;
    }

    public static String getReturnToFor(long userId) {
        final UserPagesKeeper userPagesKeeper = usersToPages.get(userId);

        if (userPagesKeeper != null) {
            return userPagesKeeper.getReturnTo();
        }

        return null;
    }

    public void sessionCreated(HttpSessionEvent event) {
        // do nothing
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        final HttpSession session = event.getSession();
        final User user = (User) session.getAttribute(SessionConstants.USER);
        Long userId = null;

        if (user != null) {
            userId = user.getId();
        }

        String returnTo = ClientUtils.getImcmsReturnToUrl(session);
        // something like "http://skurup.dev.imcode.com/servlet/PageDispatcher?page=j1x503GhYi&image_archive=yes&"
        usersToPages.put(userId, new UserPagesKeeper(returnTo, null)); // put only returnTo for now

        try {
            final String pageHash = returnTo.split("\\?")[1] // get "page=j1x503GhYi&image_archive=yes&"
                    .split("&")[0] // get "page=j1x503GhYi"
                    .split("=")[1]; // get "j1x503GhYi"

            Map sessionMap = (Map) session.getAttribute("imcode.util.HttpSessionUtils.sessionMap");
            final Object pageObject = sessionMap.get(pageHash);
            final BeanMap pageAsMap = new BeanMap(pageObject);
            DispatchCommand cancelCommand = null; // may be null, then use returnTo

            if (pageAsMap.containsKey("cancelCommand")) {
                cancelCommand = (DispatchCommand) pageAsMap.get("cancelCommand");
            }

            if (userId != null) { // rewrite value if we have cancelCommand
                usersToPages.put(userId, new UserPagesKeeper(returnTo, cancelCommand));
            }

        } catch (Exception ignore) {
            // we have other url or do not have any, just skip
        }
    }

    public interface DispatchCommand extends Serializable {
        void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException;
    }

    private class UserPagesKeeper {
        private String returnTo;
        private DispatchCommand cancelCommand;

        UserPagesKeeper(String returnTo, DispatchCommand cancelCommand) {
            this.returnTo = returnTo;
            this.cancelCommand = cancelCommand;
        }

        public String getReturnTo() {
            return returnTo;
        }

        public void setReturnTo(String returnTo) {
            this.returnTo = returnTo;
        }

        public DispatchCommand getCancelCommand() {
            return cancelCommand;
        }

        public void setCancelCommand(DispatchCommand cancelCommand) {
            this.cancelCommand = cancelCommand;
        }
    }
}
