package com.imcode.imcms.addon.imagearchive.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="user_roles_crossref")
@IdClass(UserRolesPK.class)
public class UserRoles implements Serializable {
    private static final long serialVersionUID = 582413987255427428L;
    
    @Id
    @Column(name="user_id", nullable=false)
    private int userId;
    
    @ManyToOne
    @JoinColumn(name="user_id", referencedColumnName="user_id", insertable=false, updatable=false)
    private User user;
    
    @Id
    @Column(name="role_id", nullable=false)
    private int roleId;
    
    @ManyToOne
    @JoinColumn(name="role_id", referencedColumnName="role_id", insertable=false, updatable=false)
    private Role role;
    
    
    public UserRoles() {
    }

    
    public Role getRole() {
        return role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public int getRoleId() {
        return roleId;
    }

    public void setRoleId(int roleId) {
        this.roleId = roleId;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getUserId() {
        return userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        
        if (getClass() != obj.getClass()) {
            return false;
        }
        
        final UserRoles other = (UserRoles) obj;
        if (this.userId != other.userId) {
            return false;
        }
        
        if (this.roleId != other.roleId) {
            return false;
        }
        
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + this.userId;
        hash = 67 * hash + this.roleId;
        
        return hash;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.UserRoles[userId: %d, roleId: %d]", 
                userId, roleId);
    }
}
