package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.filter.SessionListener;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Tries to restore previous session for user
 *
 * Created by Serhii from Ubrainians for Imcode
 * on 19.09.16.
 */
@Controller
public class RestoreSessionController {

    @RequestMapping("/restore")
    public void restore(HttpServletRequest request,
                        HttpServletResponse response) throws IOException, ServletException {

        User user = ClientUtils.getLoggedInUser(request);

        if (user != null) {
            final long userId = user.getId();
            final SessionListener.DispatchCommand dispatchCommand = SessionListener.getCancelCommandFor(userId);

            if (dispatchCommand != null) {
                dispatchCommand.dispatch(request, response);

            } else {
                final String returnTo = SessionListener.getReturnToFor(userId);

                if (returnTo != null) {
                    response.sendRedirect(returnTo);
                }
            }
        }
    }
}
