/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.filter;

import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.beanutils.BeanMap;

public class SessionListener
implements HttpSessionListener {
    private static Map<Long, UserPagesKeeper> usersToPages = new WeakHashMap<Long, UserPagesKeeper>();

    public static DispatchCommand getCancelCommandFor(long userId) {
        UserPagesKeeper userPagesKeeper = usersToPages.get(userId);
        if (userPagesKeeper != null) {
            return userPagesKeeper.getCancelCommand();
        }
        return null;
    }

    public static String getReturnToFor(long userId) {
        UserPagesKeeper userPagesKeeper = usersToPages.get(userId);
        if (userPagesKeeper != null) {
            return userPagesKeeper.getReturnTo();
        }
        return null;
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        User user = (User)session.getAttribute("user");
        Long userId = null;
        if (user != null) {
            userId = user.getId();
        }
        String returnTo = ClientUtils.getImcmsReturnToUrl(session);
        usersToPages.put(userId, new UserPagesKeeper(returnTo, null));
        try {
            String pageHash = returnTo.split("\\?")[1].split("&")[0].split("=")[1];
            Map sessionMap = (Map)session.getAttribute("imcode.util.HttpSessionUtils.sessionMap");
            Object pageObject = sessionMap.get(pageHash);
            BeanMap pageAsMap = new BeanMap(pageObject);
            DispatchCommand cancelCommand = null;
            if (pageAsMap.containsKey((Object)"cancelCommand")) {
                cancelCommand = (DispatchCommand)pageAsMap.get((Object)"cancelCommand");
            }
            if (userId != null) {
                usersToPages.put(userId, new UserPagesKeeper(returnTo, cancelCommand));
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    private class UserPagesKeeper {
        private String returnTo;
        private DispatchCommand cancelCommand;

        UserPagesKeeper(String returnTo, DispatchCommand cancelCommand) {
            this.returnTo = returnTo;
            this.cancelCommand = cancelCommand;
        }

        public String getReturnTo() {
            return this.returnTo;
        }

        public void setReturnTo(String returnTo) {
            this.returnTo = returnTo;
        }

        public DispatchCommand getCancelCommand() {
            return this.cancelCommand;
        }

        public void setCancelCommand(DispatchCommand cancelCommand) {
            this.cancelCommand = cancelCommand;
        }
    }

    public static interface DispatchCommand
    extends Serializable {
        public void dispatch(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;
    }
}

