/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.command.ChangeImageDataCommand;
import com.imcode.imcms.addon.imagearchive.command.ExternalFilesCommand;
import com.imcode.imcms.addon.imagearchive.command.ExternalFilesSaveImageCommand;
import com.imcode.imcms.addon.imagearchive.dto.LibrariesDto;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.json.UploadResponse;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.LibraryService;
import com.imcode.imcms.addon.imagearchive.service.file.LibrarySort;
import com.imcode.imcms.addon.imagearchive.tag.func.Functions;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import com.imcode.imcms.addon.imagearchive.util.image.Format;
import com.imcode.imcms.addon.imagearchive.util.image.ImageInfo;
import com.imcode.imcms.addon.imagearchive.util.image.ImageOp;
import com.imcode.imcms.addon.imagearchive.validator.ChangeImageDataValidator;
import com.imcode.imcms.addon.imagearchive.validator.ExternalFilesValidator;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ExternalFilesController {
    private static final Log log = LogFactory.getLog(ExternalFilesController.class);
    private static final String LIBRARY_KEY = Utils.makeKey(ExternalFilesController.class, (String)"library");
    private static final String SORT_KEY = Utils.makeKey(ExternalFilesController.class, (String)"sortBy");
    private static final String IMAGE_KEY = Utils.makeKey(ExternalFilesController.class, (String)"image");
    private static final String KEYWORDS_KEY = Utils.makeKey(ExternalFilesController.class, (String)"keywords");
    private static final String IMAGE_KEYWORDS_KEY = Utils.makeKey(ExternalFilesController.class, (String)"imageKeywords");
    @Autowired
    private Facade facade;
    @Autowired
    private Config config;

    private static LibrarySort getSortBy(HttpSession session) {
        LibrarySort sortBy = (LibrarySort)session.getAttribute(SORT_KEY);
        if (sortBy == null) {
            sortBy = LibrarySort.FILENAME;
            sortBy.setDirection(LibrarySort.DIRECTION.ASC);
            session.setAttribute(SORT_KEY, (Object)sortBy);
        }
        return sortBy;
    }

    @RequestMapping(value={"/external-files"})
    public ModelAndView indexHandler(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        if (ClientUtils.userNotLoggedIn(request)) {
            ClientUtils.redirectToLogin(response);
            return null;
        }
        ModelAndView mav = new ModelAndView("external_files/external_files");
        LibraryService libraryService = this.facade.getLibraryService();
        List libraries = libraryService.librariesToDto(libraryService.findLibraries());
        ArrayList allLibraries = new ArrayList(libraries);
        final List firstLevelLibraries = this.facade.getFileService().listFirstLevelLibraryFolders();
        CollectionUtils.filter((Iterable)libraries, (Predicate)new Predicate<LibrariesDto>(){

            public boolean evaluate(LibrariesDto lib) {
                return firstLevelLibraries.contains(new File(lib.getFilepath(), lib.getFolderNm()));
            }
        });
        LibrariesDto library = this.getLibrary(session);
        LibrarySort sortBy = ExternalFilesController.getSortBy(session);
        List libraryEntries = this.facade.getFileService().listLibraryEntries(library, sortBy);
        mav.addObject("currentLibrary", (Object)library);
        mav.addObject("libraries", (Object)libraries);
        mav.addObject("allLibraries", allLibraries);
        mav.addObject("libraryEntries", (Object)libraryEntries);
        mav.addObject("sortBy", (Object)sortBy);
        mav.addObject("externalFiles", (Object)new ExternalFilesCommand());
        return mav;
    }

    @RequestMapping(value={"/external-files/library"})
    public String changeLibraryHandler(@RequestParam(required=false) Long id, HttpSession session) {
        if (id != null) {
            LibrariesDto library;
            if (id == -1L) {
                library = LibrariesDto.userLibrary();
            } else {
                LibraryService libraryService = this.facade.getLibraryService();
                library = libraryService.convertToLibraryDto(libraryService.findLibraryById(id));
            }
            session.setAttribute(LIBRARY_KEY, (Object)library);
        }
        return "redirect:/archive/external-files";
    }

    @RequestMapping(value={"/external-files/sort"})
    public String changeSortByHandler(@RequestParam(required=false) String sortBy, HttpSession session) {
        LibrarySort sort;
        if (sortBy != null && (sort = LibrarySort.findByName((String)sortBy)) != null) {
            session.setAttribute(SORT_KEY, (Object)sort);
        }
        return "redirect:/archive/external-files";
    }

    @RequestMapping(value={"/external-files/process"})
    public ModelAndView processHandler(@ModelAttribute(value="externalFiles") ExternalFilesCommand command, BindingResult result, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        User user = ClientUtils.getLoggedInUser(request);
        if (user == null) {
            ClientUtils.redirectToLogin(response);
            return null;
        }
        LibrariesDto library = this.getLibrary(session);
        if (library == null) {
            return new ModelAndView("redirect:/archive/external-files");
        }
        if (command.getActivate() != null) {
            HashSet categories;
            Image image;
            String[] fileNames = command.getFileNames();
            if (!library.isCanUse() || fileNames == null || fileNames.length == 0) {
                return new ModelAndView("redirect:/archive/external-files");
            }
            ModelAndView mav = new ModelAndView("external_files/external_files");
            mav.addObject("activate", (Object)true);
            if (fileNames.length == 1) {
                boolean alreadyInArchive;
                boolean bl = alreadyInArchive = ClientUtils.isInArchive(this.facade.getFileService().getImageFileFromLibrary(library, fileNames[0]), this.facade).size() > 0;
                if (alreadyInArchive || (image = this.activateImage(library, fileNames[0])) == null) {
                    ModelAndView tmp = new ModelAndView("redirect:/archive/external-files");
                    tmp.addObject("activateError", (Object)true);
                    if (alreadyInArchive) {
                        tmp.addObject("alreadyInArchive", (Object)true);
                    }
                    return tmp;
                }
                session.setAttribute(IMAGE_KEY, (Object)image);
                categories = new HashSet();
                for (Role role : user.getRoles()) {
                    categories.addAll(this.facade.getRoleService().getUsableRoleCategories(role.getId()));
                }
            } else {
                ArrayList<Object[]> tuples = new ArrayList<Object[]>(fileNames.length);
                boolean generalActivationErrorOccured = false;
                boolean oneOfTheImageIsAlreadyInArchive = false;
                for (String fileName : fileNames) {
                    try {
                        ImageInfo imageInfo;
                        File imageFile = this.facade.getFileService().getImageFileFromLibrary(library, fileName);
                        boolean alreadyInArchive = ClientUtils.isInArchive(imageFile, this.facade).size() > 0;
                        oneOfTheImageIsAlreadyInArchive |= alreadyInArchive;
                        if (imageFile == null || (imageInfo = ImageOp.getImageInfo((Config)this.config, (File)imageFile)) == null || alreadyInArchive) {
                            generalActivationErrorOccured |= true;
                            continue;
                        }
                        tuples.add(new Object[]{imageFile, imageInfo, fileName});
                    }
                    catch (Exception ex) {
                        log.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                if (!tuples.isEmpty()) {
                    this.facade.getImageService().createImages(tuples);
                }
                if (generalActivationErrorOccured) {
                    ModelAndView tmp = new ModelAndView("redirect:/archive/external-files");
                    tmp.addObject("activateError", (Object)true);
                    if (oneOfTheImageIsAlreadyInArchive) {
                        tmp.addObject("alreadyInArchive", (Object)true);
                    }
                    return tmp;
                }
                return new ModelAndView("redirect:/archive/external-files");
            }
            ChangeImageDataCommand changeData = new ChangeImageDataCommand();
            changeData.fromImage(image);
            mav.addObject("changeData", (Object)changeData);
            mav.addObject("categories", categories);
            List keywords = this.facade.getImageService().findAvailableKeywords(image.getId());
            List imageKeywords = this.facade.getImageService().findImageKeywords(image.getId());
            session.setAttribute(KEYWORDS_KEY, (Object)keywords);
            session.setAttribute(IMAGE_KEYWORDS_KEY, (Object)imageKeywords);
            mav.addObject("keywords", (Object)keywords);
            mav.addObject("imageKeywords", (Object)imageKeywords);
            mav.addObject("image", (Object)image);
            mav.addObject("format", (Object)Format.findFormat((short)image.getFormat()));
            return mav;
        }
        if (command.getErase() != null && library.isUserLibrary()) {
            String[] fileNames = command.getFileNames();
            if (library.isCanChange() && fileNames != null) {
                for (String fileName : fileNames) {
                    this.facade.getFileService().deleteFileFromLibrary(library, fileName);
                }
            }
        }
        return new ModelAndView("redirect:/archive/external-files");
    }

    @RequestMapping(value={"/external-files/upload"})
    public void uploadHandler(ExternalFilesCommand externalFilesUpload, BindingResult result, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        boolean success;
        UploadResponse uploadResponse = new UploadResponse();
        String contextPath = request.getContextPath();
        LibrariesDto library = LibrariesDto.userLibrary();
        session.setAttribute(LIBRARY_KEY, (Object)library);
        if (library == null || !library.isCanChange()) {
            uploadResponse.setRedirect(contextPath + "/archive/external-files");
            Utils.writeJSON((Object)uploadResponse, (HttpServletResponse)response);
            return;
        }
        ExternalFilesValidator validator = new ExternalFilesValidator(this.facade);
        ValidationUtils.invokeValidator((Validator)validator, (Object)externalFilesUpload, (Errors)result);
        if (!result.hasErrors() && !(success = !validator.isZipFile() ? this.facade.getFileService().storeImageToLibrary(library, validator.getTempFile(), validator.getFileName()) : this.facade.getFileService().storeZipToLibrary(library, validator.getTempFile()))) {
            result.rejectValue("file", "externalFiles.fileError");
        }
        if (validator.getTempFile() != null) {
            this.facade.getFileService().deleteTemporaryFile(validator.getTempFile());
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (result.hasErrors()) {
            Iterator i$ = result.getFieldErrors().iterator();
            while (i$.hasNext()) {
                FieldError errorObj;
                FieldError error = errorObj = (FieldError)i$.next();
                errors.add(this.facade.getMessageSource().getMessage(error.getCode(), error.getArguments(), request.getLocale()));
            }
            uploadResponse.setImageErrors(errors);
        } else {
            uploadResponse.setRedirectOnAllComplete(contextPath + "/archive/external-files");
        }
        Utils.writeJSON((Object)uploadResponse, (HttpServletResponse)response);
    }

    private Image activateImage(LibrariesDto library, String fileName) {
        ImageInfo imageInfo;
        File imageFile = this.facade.getFileService().getImageFileFromLibrary(library, fileName);
        if (imageFile == null || (imageInfo = ImageOp.getImageInfo((Config)this.config, (File)imageFile)) == null) {
            return null;
        }
        try {
            return this.facade.getImageService().createImage(imageFile, imageInfo, fileName, (short)1);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @RequestMapping(value={"/external-files/change"})
    public ModelAndView changeHandler(@ModelAttribute(value="changeData") ChangeImageDataCommand changeData, BindingResult result, ExternalFilesSaveImageCommand saveCommand, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        User user = ClientUtils.getLoggedInUser(request);
        Image image = (Image)session.getAttribute(IMAGE_KEY);
        if (user == null) {
            ClientUtils.redirectToLogin(response);
            return null;
        }
        if (image == null) {
            return new ModelAndView("redirect:/archive/external-files");
        }
        if (saveCommand.getCancel() != null) {
            this.facade.getImageService().deleteImage(image.getId());
            session.removeAttribute(IMAGE_KEY);
            session.removeAttribute(KEYWORDS_KEY);
            session.removeAttribute(IMAGE_KEYWORDS_KEY);
            return new ModelAndView("redirect:/archive/external-files");
        }
        ChangeImageDataValidator validator = new ChangeImageDataValidator(this.facade);
        ValidationUtils.invokeValidator((Validator)validator, (Object)changeData, (Errors)result);
        ModelAndView mav = new ModelAndView("external_files/external_files");
        mav.addObject("activate", (Object)true);
        mav.addObject("image", (Object)image);
        List keywords = changeData.getKeywordNames();
        List imageKeywords = changeData.getImageKeywordNames();
        session.setAttribute(KEYWORDS_KEY, (Object)keywords);
        session.setAttribute(IMAGE_KEYWORDS_KEY, (Object)imageKeywords);
        mav.addObject("keywords", (Object)keywords);
        mav.addObject("imageKeywords", (Object)imageKeywords);
        if (saveCommand.getRotateLeft() != null || saveCommand.getRotateRight() != null) {
            if (saveCommand.getRotateLeft() != null) {
                this.facade.getFileService().rotateImage(image.getId().longValue(), -90, false);
            } else {
                this.facade.getFileService().rotateImage(image.getId().longValue(), 90, false);
            }
            mav.addObject("categories", (Object)this.facade.getImageService().findAvailableImageCategories(image.getId()));
            mav.addObject("imageCategories", (Object)this.facade.getImageService().findImageCategories(image.getId()));
            return mav;
        }
        if (result.hasErrors()) {
            mav.addObject("categories", (Object)this.facade.getImageService().findAvailableImageCategories(image.getId()));
            mav.addObject("imageCategories", (Object)this.facade.getImageService().findImageCategories(image.getId()));
            return mav;
        }
        changeData.toImage(image);
        try {
            this.facade.getImageService().updateData(image, changeData.getCategoryIds(), imageKeywords);
            if (saveCommand.getSaveActivate() != null) {
                session.removeAttribute(IMAGE_KEY);
                session.removeAttribute(KEYWORDS_KEY);
                session.removeAttribute(IMAGE_KEYWORDS_KEY);
                return new ModelAndView("redirect:/archive/external-files");
            }
            if (saveCommand.getSaveUse() != null) {
                session.removeAttribute(IMAGE_KEY);
                session.removeAttribute(KEYWORDS_KEY);
                session.removeAttribute(IMAGE_KEYWORDS_KEY);
                return new ModelAndView("redirect:/archive/use?id=" + image.getId());
            }
            if (saveCommand.getSaveImageCard() != null) {
                session.removeAttribute(IMAGE_KEY);
                session.removeAttribute(KEYWORDS_KEY);
                session.removeAttribute(IMAGE_KEYWORDS_KEY);
                return new ModelAndView("redirect:/archive/image/" + image.getId());
            }
            mav.addObject("categories", (Object)this.facade.getImageService().findAvailableImageCategories(image.getId()));
            mav.addObject("imageCategories", (Object)this.facade.getImageService().findImageCategories(image.getId()));
        }
        catch (Exception ex) {
            log.fatal((Object)ex.getMessage(), (Throwable)ex);
            return new ModelAndView("redirect:/archive/external-files");
        }
        return mav;
    }

    @RequestMapping(value={"/external-files/preview"})
    public ModelAndView previewHandler(@RequestParam(required=false) Long id, @RequestParam(required=false) String name) {
        LibrariesDto library = null;
        ImageInfo imageInfo = null;
        if (id != null) {
            File imageFile;
            if (id == -1L) {
                library = LibrariesDto.userLibrary();
            } else {
                LibraryService libraryService = this.facade.getLibraryService();
                library = libraryService.convertToLibraryDto(libraryService.findLibraryById(id));
            }
            name = StringUtils.trimToNull((String)name);
            if (name != null && (imageFile = this.facade.getFileService().getImageFileFromLibrary(library, name)) != null) {
                imageInfo = ImageOp.getImageInfo((Config)this.config, (File)imageFile);
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", null);
        model.put("library", library);
        model.put("imageInfo", imageInfo);
        model.put("name", name);
        return new ModelAndView("external_files/preview", model);
    }

    @RequestMapping(value={"/external-files/preview-tooltip"})
    public ModelAndView previewTooltipHandler(@RequestParam(required=false) Long id, @RequestParam(required=false) String name) {
        LibrariesDto library = null;
        ImageInfo imageInfo = null;
        Integer fileSize = null;
        String categoryNamesNeededToUse = "";
        boolean noCategories = false;
        if (id != null) {
            if (id == -1L) {
                library = LibrariesDto.userLibrary();
            } else {
                LibraryService libraryService = this.facade.getLibraryService();
                library = libraryService.convertToLibraryDto(libraryService.findLibraryById(id));
            }
            name = StringUtils.trimToNull((String)name);
            if (name != null) {
                File imageFile = this.facade.getFileService().getImageFileFromLibrary(library, name);
                List<Image> images = ClientUtils.isInArchive(imageFile, this.facade);
                if (images.size() > 0) {
                    for (Image image : images) {
                        if (!noCategories) {
                            noCategories = image.getCategories() == null || image.getCategories().size() == 0;
                        }
                        ArrayList<String> categoryNames = new ArrayList<String>();
                        for (Category cat : ClientUtils.getCategoriesRequiredToUse(image, this.facade)) {
                            categoryNames.add(cat.getName());
                        }
                        categoryNamesNeededToUse = categoryNamesNeededToUse + Functions.join(categoryNames, (String)",");
                    }
                }
                if (imageFile != null) {
                    fileSize = (int)imageFile.length();
                    imageInfo = ImageOp.getImageInfo((Config)this.config, (File)imageFile);
                }
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", null);
        model.put("library", library);
        model.put("imageInfo", imageInfo);
        model.put("name", name);
        model.put("size", fileSize);
        model.put("categoryNamesNeededToUse", categoryNamesNeededToUse);
        model.put("noCategories", noCategories);
        return new ModelAndView("external_files/preview-tooltip", model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequestMapping(value={"/external-files/image"})
    public String imageHandler(@RequestParam(required=false) Long id, @RequestParam(required=false) String name, HttpServletRequest request, HttpServletResponse response) {
        block12: {
            LibrariesDto library;
            User user = ClientUtils.getLoggedInUser(request);
            if (user == null || id == null) {
                Utils.sendErrorCode((HttpServletResponse)response, (int)404);
                return null;
            }
            if (id == -1L) {
                library = LibrariesDto.userLibrary();
            } else {
                LibraryService libraryService = this.facade.getLibraryService();
                library = libraryService.convertToLibraryDto(libraryService.findLibraryById(id));
            }
            if (library == null || !library.isCanUse()) {
                Utils.sendErrorCode((HttpServletResponse)response, (int)404);
                return null;
            }
            File imageFile = this.facade.getFileService().getImageFileFromLibrary(library, name);
            if (imageFile == null) {
                Utils.sendErrorCode((HttpServletResponse)response, (int)404);
                return null;
            }
            try {
                byte[] data = new ImageOp(this.config).input(imageFile).outputFormat(Format.JPEG).processToByteArray();
                if (data == null) {
                    Utils.sendErrorCode((HttpServletResponse)response, (int)404);
                    return null;
                }
                Utils.addNoCacheHeaders((HttpServletResponse)response);
                response.setContentLength(data.length);
                response.setContentType("image/jpeg");
                BufferedOutputStream output = null;
                try {
                    output = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    IOUtils.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)output);
                    ((OutputStream)output).flush();
                }
                catch (Exception ex) {
                    IOUtils.closeQuietly(output);
                    break block12;
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(output);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)output);
            }
            catch (Exception ex) {
                Utils.sendErrorCode((HttpServletResponse)response, (int)404);
                return null;
            }
        }
        return null;
    }

    private LibrariesDto getLibrary(HttpSession session) {
        LibrariesDto library = (LibrariesDto)session.getAttribute(LIBRARY_KEY);
        if (library != null && !library.isUserLibrary()) {
            LibraryService libraryService = this.facade.getLibraryService();
            library = libraryService.convertToLibraryDto(libraryService.findLibraryById(library.getId()));
        }
        if (library == null) {
            library = LibrariesDto.userLibrary();
            session.setAttribute(LIBRARY_KEY, (Object)library);
        }
        return library;
    }
}

