/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.command.SearchImageCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.util.KeywordComparator;
import com.imcode.imcms.addon.imagearchive.util.Pagination;
import com.imcode.imcms.addon.imagearchive.util.SessionUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import com.imcode.imcms.addon.imagearchive.validator.SearchImageValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SearchImageController {
    private static final Log log = LogFactory.getLog(SearchImageController.class);
    private static final Pattern PAGE_PATTERN = Pattern.compile("/archive/page/(\\d+)/?");
    private static final String PAGINATION_KEY = Utils.makeKey(SearchImageController.class, (String)"pagination");
    private static final String COMMAND_KEY = Utils.makeKey(SearchImageController.class, (String)"command");
    @Autowired
    private Facade facade;

    private static Pagination getPagination(HttpSession session) {
        Pagination pag = (Pagination)session.getAttribute(PAGINATION_KEY);
        if (pag == null) {
            pag = new Pagination(10);
            session.setAttribute(PAGINATION_KEY, (Object)pag);
        }
        return pag;
    }

    private static int getPage(HttpServletRequest request) {
        Matcher matcher = PAGE_PATTERN.matcher(request.getRequestURI());
        int page = 0;
        if (matcher.find()) {
            try {
                page = Integer.parseInt(matcher.group(1), 10);
                page = Math.max(page - 1, 0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return page;
    }

    @RequestMapping(value={"/archive", "/"})
    public ModelAndView indexHandler(@ModelAttribute(value="search") SearchImageCommand command, BindingResult result, @RequestParam(required=false) String returnTo, HttpServletRequest request, HttpSession session) throws IOException {
        User user;
        SearchImageCommand temporaryCommand = new SearchImageCommand();
        temporaryCommand.copyFrom(command);
        returnTo = StringUtils.trimToNull((String)returnTo);
        if (returnTo != null) {
            session.setAttribute("returnToImcms", (Object)returnTo);
        }
        if ((user = SessionUtils.getUser((HttpServletRequest)request, (HttpSession)session, (Facade)this.facade)) == null) {
            return null;
        }
        ModelAndView mav = new ModelAndView("search_image");
        Pagination pag = SearchImageController.getPagination(session);
        if (request.getParameter("show") == null) {
            SearchImageCommand cmd = (SearchImageCommand)session.getAttribute(COMMAND_KEY);
            if (cmd != null) {
                command.copyFrom(cmd);
            }
        } else {
            session.setAttribute(COMMAND_KEY, (Object)command);
            pag.setCurrentPage(0);
        }
        if (command.isClear()) {
            command.copyFrom(new SearchImageCommand());
        }
        mav.addObject("search", (Object)command);
        HashSet categories = new HashSet();
        for (Role role : user.getRoles()) {
            categories.addAll(this.facade.getRoleService().getUsableRoleCategories(role.getId()));
        }
        List keywords = this.facade.getKeywordService().getKeywords();
        Collections.sort(keywords, new KeywordComparator());
        mav.addObject("categories", categories);
        mav.addObject("keywords", (Object)keywords);
        mav.addObject("artists", (Object)"");
        SearchImageValidator validator = new SearchImageValidator(categories);
        ValidationUtils.invokeValidator((Validator)validator, (Object)temporaryCommand, (Errors)result);
        if (result.hasErrors()) {
            return mav;
        }
        session.setAttribute(COMMAND_KEY, (Object)command);
        pag.setPageSize(command.getResultsPerPage());
        List images = this.facade.getImageService().searchImages(pag, temporaryCommand);
        mav.addObject("imageCount", (Object)images.size());
        mav.addObject("images", (Object)images);
        mav.addObject("pag", (Object)pag);
        return mav;
    }

    @RequestMapping(value={"/page/*"})
    public ModelAndView pageHandler(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        User user = SessionUtils.getUser((HttpServletRequest)request, (HttpSession)session, (Facade)this.facade);
        SearchImageCommand command = (SearchImageCommand)session.getAttribute(COMMAND_KEY);
        if (command == null) {
            return new ModelAndView("redirect:/archive/");
        }
        Pagination pag = SearchImageController.getPagination(session);
        pag.setCurrentPage(SearchImageController.getPage(request));
        ModelAndView mav = new ModelAndView("search_image");
        mav.addObject("search", (Object)command);
        List keywords = this.facade.getKeywordService().getKeywords();
        Collections.sort(keywords, new KeywordComparator());
        mav.addObject("keywords", (Object)keywords);
        mav.addObject("artists", (Object)"");
        HashSet categories = new HashSet();
        for (Role role : user.getRoles()) {
            categories.addAll(this.facade.getRoleService().getUsableRoleCategories(role.getId()));
        }
        mav.addObject("categories", categories);
        ArrayList<Long> categoryIds = new ArrayList<Long>(categories.size());
        for (Category category : categories) {
            categoryIds.add(category.getId());
        }
        Long imageCount = this.facade.getImageService().searchImagesCount(categoryIds);
        mav.addObject("imageCount", (Object)imageCount);
        pag.update(imageCount.intValue());
        List images = this.facade.getImageService().searchImages(pag, command);
        mav.addObject("images", (Object)images);
        mav.addObject("pag", (Object)pag);
        return mav;
    }
}

