package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.file.ThumbSize;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.util.*;

//import com.imcode.imcms.addon.imagearchive.entity.User;

@Controller
public class GeneralController {
    private static final Log log = LogFactory.getLog(GeneralController.class);

    @Autowired
    private Facade facade;

    @RequestMapping("/language")
    public ModelAndView languageChangeHandler(
            @RequestParam(required = false) String lang,
            @RequestParam(required = false) String redir,
            HttpServletResponse response,
            HttpSession session) {
        lang = StringUtils.trimToNull(lang);
        redir = StringUtils.trimToNull(redir);

        if (lang != null && facade.getConfig().getLanguages().containsValue(lang)) {
            Locale locale = new Locale(lang);
            session.setAttribute(SessionConstants.LOCALE, locale);
            session.setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, locale);
        }

        if (redir != null) {
            try {
                response.sendRedirect(response.encodeRedirectURL(redir));
            } catch (IOException ex) {
                log.warn(ex.getMessage(), ex);
            }
        } else {
            return new ModelAndView("redirect:/archive");
        }

        return null;
    }

    @RequestMapping("/use")
    public String useInImcmsHandler(
            @RequestParam(required = false) Long id,
            HttpServletRequest request,
            HttpServletResponse response,
            HttpSession session) {

        User user = ClientUtils.getUser(request, session);

        if (user == null) {
            ClientUtils.redirectToLogin(response);
            return null;
        }

        String returnTo = ClientUtils.getImcmsReturnToUrl(session);

        if (id == null || returnTo == null) {
            return "redirect:/archive";
        }

        Image image = facade.getImageService().findById(id);
        String imageName = image.getName();
        String fileName = facade.getImcmsImageService().storeImage(
                facade.getFileService().getThumbnail(id, ThumbSize.FULL, false),
                id
        );
        String altText = StringUtils.defaultString(image.getAltText());

        StringBuilder builder = new StringBuilder(returnTo);
        builder.append("&archive_img_id=");
        builder.append(id);
        builder.append("&archive_img_nm=");
        builder.append(Utils.encodeUrl(imageName));
        builder.append("&archive_file_nm=");
        builder.append(Utils.encodeUrl(fileName));
        if (!"".equals(altText)) {
            builder.append("&archive_img_alt_text=");
            builder.append(Utils.encodeUrl(altText));
        }

        try {
            response.sendRedirect(builder.toString());
        } catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
        }

        session.removeAttribute(SessionConstants.IMCMS_RETURN_URL);

        return null;
    }

    @RequestMapping("/back")
    public String backToImcmsHandler(HttpServletResponse response, HttpSession session) {
        String returnTo = ClientUtils.getImcmsReturnToUrl(session);
        if (returnTo == null) {
            return "redirect:/archive";
        }

        session.removeAttribute(SessionConstants.IMCMS_RETURN_URL);

        try {
            response.sendRedirect(returnTo);
        } catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
        }

        return null;
    }

    @RequestMapping("/service/keyword/add")
    public void addKeywordHandler(
            @RequestParam(required = false) String keyword,
            HttpServletResponse response) {
        Utils.addNoCacheHeaders(response);

        keyword = StringUtils.trimToEmpty(keyword);

        if (StringUtils.isEmpty(keyword)) {
            Utils.sendErrorCode(response, HttpServletResponse.SC_NOT_FOUND);
        } else {
            keyword = StringUtils.substring(keyword, 0, 50);
            if (facade.getKeywordService().existsKeyword(keyword)) {
                Map<String, String> error = new HashMap<String, String>();
                error.put("error", "alreadyExists");
                Utils.writeJSON(error, response);
            } else {
                facade.getKeywordService().createKeyword(keyword);
                Map<String, String> newKeyword = new HashMap<String, String>();
                newKeyword.put("newKeyword", keyword);
                Utils.writeJSON(newKeyword, response);
            }
        }
    }

    @RequestMapping("/service/keyword/list")
    public void keywordListHandler(@RequestParam(required = false) String text,
                                   HttpServletRequest request,
                                   HttpServletResponse response,
                                   HttpSession session) {

        User user = ClientUtils.getUser(request, session);
        if (user == null) {
            return;
        }

        List<String> keywords = new ArrayList<String>();
        text = StringUtils.trimToEmpty(text);
        if (!text.isEmpty()) {
            text = "%" + text + "%";
            for (Keyword keyword : facade.getKeywordService().findKeywordsByNameLike(text)) {
                keywords.add(keyword.getName());
            }
        }

        Map<String, List<String>> tmp = new HashMap<String, List<String>>();
        tmp.put("keywords", keywords);
        Utils.writeJSON(tmp, response);
    }
}
