package com.imcode.imcms.addon.imagearchive.util;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.SessionConstants;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.UserService;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ClientUtils {
    private static final Log log = LogFactory.getLog(ClientUtils.class);

    public static User getUser(HttpServletRequest request, HttpSession session) {
        User user = (User) session.getAttribute(SessionConstants.USER);
//        Long userId = 1L;
		Long userId = null;
        // do not forget to change to userId = null when commit or deploy !!!
        Object cms = request.getAttribute(SessionConstants.CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE);
        if (cms != null) {
            BeanMap introspected = new BeanMap(cms);
            if (introspected.containsKey("currentUser")) {
                BeanMap objectUser = new BeanMap(introspected.get("currentUser"));

                userId = Long.valueOf(ObjectUtils.toString(objectUser.get("id"), "2"));
            }
        }

        if (user == null || Long.valueOf(user.getId()).equals(userId) || user.isDefault()) {
            UserService service = Utils.getFacade().getUserService();
            user = service.findUserById(userId);
            session.setAttribute(SessionConstants.USER, user);
        }

        return user;
    }

    public static String getImcmsReturnToUrl(HttpSession session) {
        return (String) session.getAttribute(SessionConstants.IMCMS_RETURN_URL);
    }

    public static boolean userNotLoggedIn(HttpServletRequest request, HttpSession session) {
        User user = getUser(request, session);
        return (user == null || user.isDefault());
    }

    public static void redirectToLogin(HttpServletResponse response) {
        try {
            Config config = Utils.getFacade().getConfig();
            response.sendRedirect(String.format("http://%s/%s", config.getImcmsRootUrl(), config.getImcmsLoginUrlPath()));
        } catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
        }
    }

    public static List<Image> isInArchive(File img, Facade facade) {
        List<Image> sameImages = new ArrayList<Image>();
        List<Image> archiveImages = facade.getImageService().getAllImages();
        for (Image image : archiveImages) {
            if (img != null && image.getName().equals(img.getName()) && image.getFileSize() == img.length()) {
                sameImages.add(image);
            }
        }

        return sameImages;
    }

    public static Collection<Category> getCategoriesRequiredToUse(Image img, Facade facader) {
        List<Category> userCategories = facader.getCategoryService().getCategories();
        List<Category> imageCategories = img.getCategories();
        Collection<Category> categoriesesUserCantUse = Collections.emptyList();
        if (imageCategories != null) {
            categoriesesUserCantUse = CollectionUtils.subtract(imageCategories, userCategories);
        }

        return categoriesesUserCantUse;
    }

    public static boolean canAccessPreferences(User user, Facade facade) {
        return user.isSuperadmin() || isImageAdmin(user, facade);
    }

    public static boolean isImageAdmin(User user, Facade facade) {
        Role role = facade.getRoleService().getRoleByName("Bildadmin");
        return role != null && user.hasRole(role);
    }

    private ClientUtils() {
    }

    public static boolean canUseOrChangeImage(Image image, User user, Facade facade) {
        return canChangeImage(image, user, facade) || canUseImage(image, user, facade);
    }

    public static boolean canUseImage(Image image, User user, Facade facade) {
        return user.isSuperadmin() || isImageAdmin(user, facade) || image.getCategories().size() == 0 ||
                CollectionUtils.containsAny(
                        facade.getRoleService().getUsableRoleCategories(user.getRoles().toArray(new Role[]{})),
                        image.getCategories()
                );
    }

    public static boolean canChangeImage(Image image, User user, Facade facade) {
        image.setCanChange(user.isSuperadmin() || isImageAdmin(user, facade) || image.getCategories().size() == 0 ||
                CollectionUtils.containsAny(
                        facade.getRoleService().getChangeableRoleCategories(user.getRoles().toArray(new Role[]{})),
                        image.getCategories()
                ));
        return image.isCanChange();
    }
}
