/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Keyword;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.file.ThumbSize;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Controller
public class GeneralController {
    private static final Log log = LogFactory.getLog(GeneralController.class);
    @Autowired
    private Facade facade;

    @RequestMapping(value={"/language"})
    public ModelAndView languageChangeHandler(@RequestParam(required=false) String lang, @RequestParam(required=false) String redir, HttpServletResponse response, HttpSession session) {
        lang = StringUtils.trimToNull((String)lang);
        redir = StringUtils.trimToNull((String)redir);
        if (lang != null && this.facade.getConfig().getLanguages().containsValue((Object)lang)) {
            Locale locale = new Locale(lang);
            session.setAttribute("locale", (Object)locale);
            session.setAttribute(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)locale);
        }
        if (redir != null) {
            try {
                response.sendRedirect(response.encodeRedirectURL(redir));
            }
            catch (IOException ex) {
                log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            return new ModelAndView("redirect:/archive");
        }
        return null;
    }

    @RequestMapping(value={"/use"})
    public String useInImcmsHandler(@RequestParam(required=false) Long id, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        User user = ClientUtils.getUser(request, session);
        String returnTo = ClientUtils.getImcmsReturnToUrl(session);
        if (user == null) {
            ClientUtils.redirectToLogin(response);
            return null;
        }
        if (id == null || returnTo == null) {
            return "redirect:/archive";
        }
        Image image = this.facade.getImageService().findById(id);
        String imageName = image.getName();
        String fileName = this.facade.getImcmsImageService().storeImage(this.facade.getFileService().getThumbnail(id.longValue(), ThumbSize.FULL, false), id.longValue());
        String altText = StringUtils.defaultString((String)image.getAltText());
        StringBuilder builder = new StringBuilder(returnTo);
        builder.append("&archive_img_id=");
        builder.append(id);
        builder.append("&archive_img_nm=");
        builder.append(Utils.encodeUrl((String)imageName));
        builder.append("&archive_file_nm=");
        builder.append(Utils.encodeUrl((String)fileName));
        if (!"".equals(altText)) {
            builder.append("&archive_img_alt_text=");
            builder.append(Utils.encodeUrl((String)altText));
        }
        try {
            response.sendRedirect(builder.toString());
        }
        catch (IOException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        session.removeAttribute("returnToImcms");
        return null;
    }

    @RequestMapping(value={"/back"})
    public String backToImcmsHandler(HttpServletResponse response, HttpSession session) {
        String returnTo = ClientUtils.getImcmsReturnToUrl(session);
        if (returnTo == null) {
            return "redirect:/archive";
        }
        session.removeAttribute("returnToImcms");
        try {
            response.sendRedirect(returnTo);
        }
        catch (IOException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    @RequestMapping(value={"/service/keyword/add"})
    public void addKeywordHandler(@RequestParam(required=false) String keyword, HttpServletResponse response) {
        Utils.addNoCacheHeaders((HttpServletResponse)response);
        keyword = StringUtils.trimToEmpty((String)keyword);
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            Utils.sendErrorCode((HttpServletResponse)response, (int)404);
        } else {
            keyword = StringUtils.substring((String)keyword, (int)0, (int)50);
            if (this.facade.getKeywordService().existsKeyword(keyword)) {
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("error", "alreadyExists");
                Utils.writeJSON(error, (HttpServletResponse)response);
            } else {
                this.facade.getKeywordService().createKeyword(keyword);
                HashMap<String, String> newKeyword = new HashMap<String, String>();
                newKeyword.put("newKeyword", keyword);
                Utils.writeJSON(newKeyword, (HttpServletResponse)response);
            }
        }
    }

    @RequestMapping(value={"/service/keyword/list"})
    public void keywordListHandler(@RequestParam(required=false) String text, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        User user = ClientUtils.getUser(request, session);
        if (user == null) {
            return;
        }
        ArrayList<String> keywords = new ArrayList<String>();
        if (!(text = StringUtils.trimToEmpty((String)text)).isEmpty()) {
            text = "%" + text + "%";
            for (Keyword keyword : this.facade.getKeywordService().findKeywordsByNameLike(text)) {
                keywords.add(keyword.getName());
            }
        }
        HashMap<String, ArrayList<String>> tmp = new HashMap<String, ArrayList<String>>();
        tmp.put("keywords", keywords);
        Utils.writeJSON(tmp, (HttpServletResponse)response);
    }
}

