package com.imcode.imcms.addon.imagearchive.util;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.UserService;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang3.ObjectUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionUtils {
	private final static String CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE = "com.imcode.imcms.ImcmsSystem";

    private static boolean shouldBeRedirectedToLogin;
    private static boolean shouldBeRedirectedToArchive;

	private SessionUtils() {
	}

	public static User getUser(HttpServletRequest request, HttpSession session, Facade facade) {
		User user = (User) session.getAttribute(SessionConstants.USER);
        Long userId = 1L;
//		Long userId = null;
        // do not forget to change to userId = null when commit or deploy !!! 
		Object cms = request.getAttribute(CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE);
		if (cms != null) {
			BeanMap introspected = new BeanMap(cms);
			if (introspected.containsKey("currentUser")) {
				BeanMap objectUser = new BeanMap(introspected.get("currentUser"));

				userId = Long.valueOf(ObjectUtils.toString(objectUser.get("id"), "2"));
			}
		}

		if (user == null || Long.valueOf(user.getId()).equals(userId) || user.isDefault()) {
			UserService service = facade.getUserService();
			user = service.findUserById(userId);
			session.setAttribute(SessionConstants.USER, user);
		}

		return user;
	}

	public static String getImcmsReturnToUrl(HttpSession session) {
		return (String) session.getAttribute(SessionConstants.IMCMS_RETURN_URL);
	}

    public static boolean userNotLoggedIn(HttpServletRequest request, HttpSession session) {
        SessionUtils.shouldBeRedirectedToLogin = false;
        SessionUtils.shouldBeRedirectedToArchive = false;

        User user = SessionUtils.getUser(request, session, Utils.getFacade());

        if (user == null) {
            SessionUtils.shouldBeRedirectedToLogin = true;

        } else if (user.isDefault()) {
            SessionUtils.shouldBeRedirectedToArchive = true;
        }

        return (SessionUtils.shouldBeRedirectedToLogin || SessionUtils.shouldBeRedirectedToArchive);
    }

    public static String getRedirect(HttpServletResponse response) {
        if (SessionUtils.shouldBeRedirectedToLogin) {
            ClientUtils.redirectToLogin(response, Utils.getFacade());
            SessionUtils.shouldBeRedirectedToLogin = false;
            return null;

        } else if (SessionUtils.shouldBeRedirectedToArchive) {
            SessionUtils.shouldBeRedirectedToArchive = false;
            return "redirect:/archive";

        } else throw new UnsupportedOperationException("Getting redirect when user should not been redirected");
    }
}
