package com.imcode.imcms.addon.imagearchive.util;

import com.imcode.imcms.addon.imagearchive.SessionConstants;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.UserService;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang3.ObjectUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionUtils {
	private final static String CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE = "com.imcode.imcms.ImcmsSystem";

    private static Boolean shouldBeRedirectedToLogin;
    private static Boolean shouldBeRedirectedToArchive;

	private SessionUtils() {
	}

	public static User getUser(HttpServletRequest request, HttpSession session, Facade facade) {
		User user = (User) session.getAttribute(SessionConstants.USER);
//        Long userId = 1L;
		Long userId = null;
        // do not forget to change to userId = null when commit or deploy !!! 
		Object cms = request.getAttribute(CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE);
		if (cms != null) {
			BeanMap introspected = new BeanMap(cms);
			if (introspected.containsKey("currentUser")) {
				BeanMap objectUser = new BeanMap(introspected.get("currentUser"));

				userId = Long.valueOf(ObjectUtils.toString(objectUser.get("id"), "2"));
			}
		}

		if (user == null || Long.valueOf(user.getId()).equals(userId) || user.isDefault()) {
			UserService service = facade.getUserService();
			user = service.findUserById(userId);
			session.setAttribute(SessionConstants.USER, user);
		}

		return user;
	}

	public static String getImcmsReturnToUrl(HttpSession session) {
		return (String) session.getAttribute(SessionConstants.IMCMS_RETURN_URL);
	}

    public static boolean userNotLoggedIn(HttpServletRequest request, HttpSession session) {
        User user = SessionUtils.getUser(request, session, Utils.getFacade());

        if (user == null) {
            shouldBeRedirectedToLogin = true;

        } else if (user.isDefault()) {
            shouldBeRedirectedToArchive = true;
        }

        return shouldBeRedirectedToLogin || shouldBeRedirectedToArchive;
    }

    public static String getRedirect(HttpServletResponse response) {
        if (shouldBeRedirectedToLogin) {
            ClientUtils.redirectToLogin(response, Utils.getFacade());
            shouldBeRedirectedToLogin = null;
            return null;

        } else if (shouldBeRedirectedToArchive) {
            shouldBeRedirectedToArchive = null;
            return "redirect:/archive";

        } else throw new UnsupportedOperationException("Getting redirect when user should not been redirected");
    }
}
