package com.imcode.imcms.addon.imagearchive.util;

import com.imcode.imcms.addon.imagearchive.Config;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.Image;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ClientUtils {
    private static final Log log = LogFactory.getLog(ClientUtils.class);

    public static void redirectToLogin(HttpServletResponse response, Facade facade) {
        try {
            Config config = facade.getConfig();
            response.sendRedirect(String.format("http://%s/%s", config.getImcmsRootUrl(), config.getImcmsLoginUrlPath()));
        } catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
        }
    }

    public static List<Image> isInArchive(File img, Facade facade) {
        List<Image> sameImages = new ArrayList<Image>();
        List<Image> archiveImages = facade.getImageService().getAllImages();
        for (Image image : archiveImages) {
            if (img != null && image.getName().equals(img.getName()) && image.getFileSize() == img.length()) {
                sameImages.add(image);
            }
        }

        return sameImages;
    }

    public static Collection<Category> getCategoriesRequiredToUse(Image img, Facade facader) {
        List<Category> userCategories = facader.getCategoryService().getCategories();
        List<Category> imageCategories = img.getCategories();
        Collection<Category> categoriesesUserCantUse = Collections.emptyList();
        if (imageCategories != null) {
            categoriesesUserCantUse = CollectionUtils.subtract(imageCategories, userCategories);
        }

        return categoriesesUserCantUse;
    }

    public static boolean canAccessPreferences(User user, Facade facade) {
        return user.isSuperadmin() || isImageAdmin(user, facade);
    }

    public static boolean isImageAdmin(User user, Facade facade) {
        Role role = facade.getRoleService().getRoleByName("Bildadmin");
        return role != null && user.hasRole(role);
    }

    private ClientUtils() {
    }

    public static boolean canUseOrChangeImage(Image image, User user, Facade facade) {
        return canChangeImage(image, user, facade) || canUseImage(image, user, facade);
    }

    public static boolean canUseImage(Image image, User user, Facade facade) {
        return user.isSuperadmin() || isImageAdmin(user, facade) || image.getCategories().size() == 0 ||
                CollectionUtils.containsAny(
                        facade.getRoleService().getUsableRoleCategories(user.getRoles().toArray(new Role[]{})),
                        image.getCategories()
                );
    }

    public static boolean canChangeImage(Image image, User user, Facade facade) {
        image.setCanChange(user.isSuperadmin() || isImageAdmin(user, facade) || image.getCategories().size() == 0 ||
                CollectionUtils.containsAny(
                        facade.getRoleService().getChangeableRoleCategories(user.getRoles().toArray(new Role[]{})),
                        image.getCategories()
                ));
        return image.isCanChange();
    }
}
