package com.imcode.imcms.addon.imagearchive.service;

import com.imcode.imcms.addon.imagearchive.entity.ClientKeyword;
import com.imcode.imcms.addon.imagearchive.service.exception.KeywordExistsException;

import java.util.List;

public interface ClientKeywordService {
    ClientKeyword createKeyword(final String newKeywordName) throws KeywordExistsException;

    List<ClientKeyword> getKeywords();

    void deleteKeyword(final Long keywordId);

    void updateKeyword(final Long keywordId, final String keywordName) throws KeywordExistsException;

    boolean existsKeyword(final String newKeywordName);

    List<ClientKeyword> findKeywordsByNameLike(String text);

    ClientKeyword getKeyword(Long id);

    ClientKeyword findByName(String name);

    ClientKeyword createOrGet(String name);

    List<ClientKeyword> findByName(List<String> names);
}
