package com.imcode.imcms.addon.imagearchive.entity;

import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Entity
@Table(name = "archive_keywords")
public class ClientKeyword implements Serializable, Comparable<ClientKeyword> {
    private static final long serialVersionUID = -5618267783578349726L;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue
    private Long id;

    @Column(name = "keyword_nm", length = 50, nullable = false)
    private String name;

    @Column(name = "created_dt", nullable = false)
    @Temporal(TemporalType.TIMESTAMP)
    private Date createdDt = new Date();

    @ManyToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    @LazyCollection(LazyCollectionOption.TRUE)
    @JoinTable(
            name = "archive_image_keywords",
            inverseJoinColumns = @JoinColumn(name = "image_id", nullable = false),
            joinColumns = @JoinColumn(name = "keyword_id", nullable = false)
    )
    private List<Image> images;


    public ClientKeyword() {
    }

    public ClientKeyword(String name) {
        this.name = name;
    }

    @PrePersist
    public void prePersist() {
        createdDt = new Date();
    }

    public Date getCreatedDt() {
        return createdDt;
    }

    public void setCreatedDt(Date createdDt) {
        this.createdDt = createdDt;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ClientKeyword)) return false;

        ClientKeyword that = (ClientKeyword) o;

        if (!id.equals(that.id)) return false;
        if (!name.equals(that.name)) return false;
        return createdDt.equals(that.createdDt);
    }

    @Override
    public int hashCode() {
        int result = id.hashCode();
        result = 31 * result + name.hashCode();
        result = 31 * result + createdDt.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.ClientKeywords[id: %d, name: %s]",
                id, name);
    }

    public int compareTo(ClientKeyword o) {
        return this.id.compareTo(o.id);
    }

    public List<Image> getImages() {
        return images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }
}
