/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.service.impl;

import com.imcode.imcms.addon.imagearchive.entity.ClientKeyword;
import com.imcode.imcms.addon.imagearchive.repository.ClientKeywordsRepository;
import com.imcode.imcms.addon.imagearchive.service.ClientKeywordService;
import com.imcode.imcms.addon.imagearchive.service.exception.KeywordExistsException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class ClientKeywordServiceImpl
implements ClientKeywordService {
    @Autowired
    private ClientKeywordsRepository keywordsRepository;

    @Override
    public ClientKeyword createKeyword(String newKeywordName) throws KeywordExistsException {
        if (this.existsKeyword(newKeywordName)) {
            throw new KeywordExistsException();
        }
        ClientKeyword keyword = new ClientKeyword();
        keyword.setName(newKeywordName);
        this.keywordsRepository.save(keyword);
        return keyword;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<ClientKeyword> getKeywords() {
        List keywords = this.keywordsRepository.findAll();
        return keywords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void deleteKeyword(Long keywordId) {
        if (!this.keywordsRepository.exists(keywordId)) {
            return;
        }
        this.removeKeywordImages(keywordId);
        try {
            this.keywordsRepository.delete(keywordId);
        }
        catch (Exception ignore) {
            ClientKeyword keyword = (ClientKeyword)this.keywordsRepository.getOne(keywordId);
            this.keywordsRepository.save(keyword);
        }
        finally {
            try {
                this.keywordsRepository.flush();
            }
            catch (Exception exception) {}
        }
    }

    @Transactional
    private void removeKeywordImages(Long keywordId) {
        ClientKeyword keyword = (ClientKeyword)this.keywordsRepository.getOne(keywordId);
        keyword.getImages().clear();
        this.keywordsRepository.save(keyword);
        this.keywordsRepository.flush();
    }

    @Override
    public void updateKeyword(Long keywordId, String keywordName) throws KeywordExistsException {
        ClientKeyword keyword = (ClientKeyword)this.keywordsRepository.findOne(keywordId);
        if (keyword != null) {
            keyword.setName(keywordName);
            this.keywordsRepository.save(keyword);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean existsKeyword(String newKeywordName) {
        return this.keywordsRepository.findByName(newKeywordName) != null;
    }

    @Override
    public List<ClientKeyword> findKeywordsByNameLike(String text) {
        return this.keywordsRepository.findByNameLike(text);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public ClientKeyword getKeyword(Long id) {
        return (ClientKeyword)this.keywordsRepository.findOne(id);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public ClientKeyword findByName(String name) {
        return this.keywordsRepository.findByName(name);
    }

    @Override
    public ClientKeyword createOrGet(String name) {
        try {
            return this.createKeyword(name);
        }
        catch (KeywordExistsException e) {
            return this.findByName(name);
        }
    }

    @Override
    public List<ClientKeyword> findByName(List<String> names) {
        ArrayList<ClientKeyword> keywords = new ArrayList<ClientKeyword>();
        for (String name : names) {
            ClientKeyword keyword = this.findByName(name);
            if (keyword == null) continue;
            keywords.add(keyword);
        }
        return keywords;
    }
}

