/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.controller.web;

import com.imcode.imcms.addon.imagearchive.command.CreateCategoryCommand;
import com.imcode.imcms.addon.imagearchive.command.CreateKeywordCommand;
import com.imcode.imcms.addon.imagearchive.command.EditCategoryCommand;
import com.imcode.imcms.addon.imagearchive.command.EditKeywordCommand;
import com.imcode.imcms.addon.imagearchive.command.PreferencesActionCommand;
import com.imcode.imcms.addon.imagearchive.command.SaveLibraryRolesCommand;
import com.imcode.imcms.addon.imagearchive.command.SaveRoleCategoriesCommand;
import com.imcode.imcms.addon.imagearchive.entity.Category;
import com.imcode.imcms.addon.imagearchive.entity.CategoryRoles;
import com.imcode.imcms.addon.imagearchive.entity.CategoryType;
import com.imcode.imcms.addon.imagearchive.entity.Library;
import com.imcode.imcms.addon.imagearchive.entity.Role;
import com.imcode.imcms.addon.imagearchive.entity.User;
import com.imcode.imcms.addon.imagearchive.repository.CategoryRolesRepository;
import com.imcode.imcms.addon.imagearchive.service.ClientKeywordService;
import com.imcode.imcms.addon.imagearchive.service.Facade;
import com.imcode.imcms.addon.imagearchive.service.exception.CategoryExistsException;
import com.imcode.imcms.addon.imagearchive.service.exception.KeywordExistsException;
import com.imcode.imcms.addon.imagearchive.service.impl.ClientCategoryService;
import com.imcode.imcms.addon.imagearchive.util.ClientUtils;
import com.imcode.imcms.addon.imagearchive.util.SessionUtils;
import com.imcode.imcms.addon.imagearchive.util.Utils;
import com.imcode.imcms.addon.imagearchive.validator.CreateCategoryValidator;
import com.imcode.imcms.addon.imagearchive.validator.CreateKeywordValidator;
import com.imcode.imcms.addon.imagearchive.validator.EditCategoryValidator;
import com.imcode.imcms.addon.imagearchive.validator.EditKeywordValidator;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class PreferencesController {
    private static final Log log = LogFactory.getLog(PreferencesController.class);
    private static final String ROLE_KEY = Utils.makeKey(PreferencesController.class, (String)"role");
    private static final String LIBRARY_KEY = Utils.makeKey(PreferencesController.class, (String)"library");
    @Autowired
    private Facade facade;
    @Autowired
    private ClientCategoryService clientCategoryService;
    @Autowired
    private ClientKeywordService clientKeywordService;
    @Autowired
    private CategoryRolesRepository categoryRolesRepository;

    private static Role getRole(HttpSession session, List<Role> roles) {
        Role role = (Role)session.getAttribute(ROLE_KEY);
        if (role == null && roles != null) {
            role = roles.get(0);
            session.setAttribute(ROLE_KEY, (Object)role);
        }
        return role;
    }

    private static Library getLibrary(HttpSession session, List<Library> libraries) {
        Library library = (Library)session.getAttribute(LIBRARY_KEY);
        if (library != null && libraries != null) {
            boolean exists = false;
            for (Library lib : libraries) {
                if (lib.getId() != library.getId()) continue;
                exists = true;
                break;
            }
            if (!exists) {
                library = null;
                session.removeAttribute(LIBRARY_KEY);
            }
        }
        if (library == null && libraries != null && !libraries.isEmpty()) {
            library = libraries.get(0);
            session.setAttribute(LIBRARY_KEY, (Object)library);
        }
        return library;
    }

    @RequestMapping(value={"/preferences"})
    public String indexHandler(@ModelAttribute PreferencesActionCommand actionCommand, @ModelAttribute(value="createCategory") CreateCategoryCommand createCategoryCommand, BindingResult createCategoryResult, @ModelAttribute(value="editCategory") EditCategoryCommand editCategoryCommand, BindingResult editCategoryResult, @ModelAttribute(value="createKeyword") CreateKeywordCommand createKeywordCommand, BindingResult createKeywordResult, @ModelAttribute(value="editKeyword") EditKeywordCommand editKeywordCommand, BindingResult editKeywordResult, @ModelAttribute(value="saveLibraryRoles") SaveLibraryRolesCommand librariesCommand, BindingResult librariesResult, @ModelAttribute(value="saveCategories") SaveRoleCategoriesCommand roleCategoriesCommand, HttpServletRequest request, HttpServletResponse response, HttpSession session, Map<String, Object> model) {
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            ClientUtils.redirectToLogin(response, this.facade);
            return null;
        }
        if (!ClientUtils.canAccessPreferences(user, this.facade)) {
            return "redirect:/archive";
        }
        this.facade.getLibraryService().syncLibraryFolders();
        List roles = this.facade.getRoleService().getAllRoles();
        Role role = PreferencesController.getRole(session, roles);
        Role previousRole = (Role)session.getAttribute("previousRole");
        if (previousRole != null && !role.equals((Object)previousRole)) {
            model.put("editingRoles", true);
        }
        session.setAttribute("previousRole", (Object)role);
        model.put("currentRole", role);
        List libraries = this.facade.getLibraryService().findLibraries();
        final List firstLevelLibraries = this.facade.getFileService().listFirstLevelLibraryFolders();
        CollectionUtils.filter((Iterable)libraries, (Predicate)new Predicate<Library>(){

            public boolean evaluate(Library lib) {
                return firstLevelLibraries.contains(new File(lib.getFilepath(), lib.getFolderNm()));
            }
        });
        Library library = PreferencesController.getLibrary(session, libraries);
        session.setAttribute("previousLibrary", (Object)library);
        model.put("currentLibrary", library);
        if (actionCommand.isCreateCategory()) {
            this.processCreateCategory(createCategoryCommand, createCategoryResult);
            model.put("editingCategories", true);
        } else if (actionCommand.isEditCategory()) {
            this.processEditCategory(editCategoryCommand);
            model.put("editingCategories", true);
        } else if (actionCommand.isSaveCategory()) {
            this.processSaveCategory(editCategoryCommand, editCategoryResult);
            model.put("editingCategories", true);
        } else if (actionCommand.isRemoveCategory()) {
            this.processRemoveCategory(editCategoryCommand);
            model.put("editingCategories", true);
        } else if (actionCommand.isCreateKeyword()) {
            this.processCreateKeyword(createKeywordCommand, createKeywordResult);
            model.put("editingKeywords", true);
        } else if (actionCommand.isSaveKeyword()) {
            this.processSaveKeyword(editKeywordCommand, editKeywordResult);
            model.put("editingKeywords", true);
        } else if (actionCommand.isRemoveKeyword()) {
            this.processRemoveKeyword(editKeywordCommand);
            model.put("editingKeywords", true);
        } else if (actionCommand.isSaveLibraryRoles() && library != null && librariesCommand.getLibraryRoles() != null) {
            this.processSaveLibraryRoles(librariesCommand, librariesResult, model);
            model.put("editingLibraries", true);
        } else if (actionCommand.isSaveRoleCategories()) {
            this.processSaveRoleCategories(roleCategoriesCommand, model);
            model.put("editingRoles", true);
        }
        if (!actionCommand.isSaveLibraryRoles() && library != null) {
            librariesCommand.setLibraryNm(library.getLibraryNm());
        }
        List libraryRoles = Collections.emptyList();
        if (library != null) {
            libraryRoles = this.facade.getLibraryService().findLibraryRoles(library.getId());
        }
        model.put("availableLibraryRoles", null);
        model.put("libraryRoles", libraryRoles);
        List categoryRoles = this.facade.getRoleService().getCategoryRolesByRole(role);
        model.put("categoryRoles", categoryRoles);
        Collection categoryTypes = this.facade.getCategoryTypeService().getCategoryTypes();
        CollectionUtils.filter((Iterable)categoryTypes, (Predicate)new Predicate<CategoryType>(){

            public boolean evaluate(CategoryType categoryType) {
                return categoryType.isImageArchive();
            }
        });
        Collection typeCategoriesId = this.facade.getCategoryTypeService().getCategoryIdsOfTypes(categoryTypes);
        Collection typeCategories = this.facade.getCategoryService().getCategories(typeCategoriesId);
        model.put("categoryTypes", categoryTypes);
        model.put("categories", typeCategories);
        model.put("keywords", this.facade.getKeywordService().getKeywords());
        model.put("roles", roles);
        model.put("libraries", libraries);
        model.put("freeCategories", typeCategories);
        model.put("roleCategories", typeCategories);
        model.put("allCategories", typeCategories);
        return "preferences";
    }

    private void processCreateCategory(CreateCategoryCommand command, BindingResult result) {
        CreateCategoryValidator validator = new CreateCategoryValidator();
        ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
        if (!result.hasErrors()) {
            String categoryName = command.getCreateCategoryName();
            Integer categoryTypeId = command.getCreateCategoryType();
            try {
                Long clientCatId;
                Long catId = this.facade.getCategoryService().createCategory(categoryName, categoryTypeId).getId();
                Long l = clientCatId = this.clientCategoryService.getCategory(categoryName) == null ? this.clientCategoryService.createCategory(categoryName, categoryTypeId.longValue()).getId() : this.clientCategoryService.getCategory(categoryName).getId();
                while (!catId.equals(clientCatId)) {
                    if (catId < clientCatId) {
                        this.facade.getCategoryService().deleteCategory(catId);
                        catId = this.facade.getCategoryService().createCategory(categoryName, categoryTypeId).getId();
                        continue;
                    }
                    if (catId <= clientCatId) continue;
                    List categoryRoles = this.categoryRolesRepository.findByCategoryId(clientCatId.intValue());
                    if (!categoryRoles.isEmpty()) {
                        this.categoryRolesRepository.delete((Iterable)categoryRoles);
                    }
                    this.clientCategoryService.deleteCategory(clientCatId);
                    clientCatId = this.clientCategoryService.createCategory(categoryName, categoryTypeId.longValue()).getId();
                    if (categoryRoles.isEmpty()) continue;
                    for (CategoryRoles categoryRole : categoryRoles) {
                        categoryRole.setCategoryId(clientCatId.intValue());
                    }
                    this.categoryRolesRepository.save((Iterable)categoryRoles);
                }
                command.setCreateCategoryName("");
                command.setCreateCategoryType(0);
            }
            catch (CategoryExistsException ex) {
                result.rejectValue("createCategoryName", "preferences.categoryExistsError");
            }
        }
    }

    private void processEditCategory(EditCategoryCommand command) {
        Category category = this.facade.getCategoryService().getCategory(Long.valueOf(command.getEditCategoryId()));
        if (category != null) {
            command.setShowEditCategory(true);
            command.setEditCategoryName(category.getName());
        }
    }

    private void processSaveCategory(EditCategoryCommand command, BindingResult result) {
        EditCategoryValidator validator = new EditCategoryValidator();
        ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
        if (!result.hasErrors()) {
            long categoryId = command.getEditCategoryId();
            String newName = command.getEditCategoryName();
            try {
                this.facade.getCategoryService().updateCategory(Long.valueOf(categoryId), newName);
                this.clientCategoryService.updateCategory(categoryId, newName);
            }
            catch (CategoryExistsException ex) {
                result.rejectValue("editCategoryName", "preferences.categoryExistsError");
            }
        }
    }

    private void processRemoveCategory(EditCategoryCommand command) {
        int categoryId = command.getEditCategoryId();
        List categoryRoles = this.categoryRolesRepository.findByCategoryId(categoryId);
        this.facade.getCategoryService().deleteCategory(Long.valueOf(categoryId));
        this.categoryRolesRepository.delete((Iterable)categoryRoles);
        this.clientCategoryService.deleteCategory(Long.valueOf(categoryId));
        command.setEditCategoryName("");
        command.setShowEditCategory(false);
    }

    private void processCreateKeyword(CreateKeywordCommand command, BindingResult result) {
        CreateKeywordValidator validator = new CreateKeywordValidator();
        ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
        if (!result.hasErrors()) {
            String keywordName = command.getCreateKeywordName().toLowerCase();
            try {
                Long clientKeywordId;
                this.facade.getKeywordService().createKeyword(keywordName);
                this.clientKeywordService.createKeyword(keywordName);
                Long keywordId = this.facade.getKeywordService().createKeyword(keywordName).getId();
                Long l = clientKeywordId = this.clientKeywordService.findByName(keywordName) == null ? this.clientKeywordService.createKeyword(keywordName).getId() : this.clientKeywordService.findByName(keywordName).getId();
                while (!keywordId.equals(clientKeywordId)) {
                    if (keywordId < clientKeywordId) {
                        this.facade.getKeywordService().deleteKeyword(keywordId);
                        keywordId = this.facade.getKeywordService().createKeyword(keywordName).getId();
                        continue;
                    }
                    if (keywordId <= clientKeywordId) continue;
                    this.clientKeywordService.deleteKeyword(clientKeywordId);
                    clientKeywordId = this.clientKeywordService.createKeyword(keywordName).getId();
                }
                command.setCreateKeywordName("");
            }
            catch (KeywordExistsException ex) {
                result.rejectValue("createKeywordName", "preferences.keywordExistsError");
            }
        }
    }

    private void processSaveKeyword(EditKeywordCommand command, BindingResult result) {
        EditKeywordValidator validator = new EditKeywordValidator();
        ValidationUtils.invokeValidator((Validator)validator, (Object)command, (Errors)result);
        if (!result.hasErrors()) {
            long keywordId = command.getEditKeywordId();
            String KeywordName = command.getEditKeywordName();
            try {
                this.facade.getKeywordService().updateKeyword(Long.valueOf(keywordId), KeywordName);
                this.clientKeywordService.updateKeyword(keywordId, KeywordName);
            }
            catch (KeywordExistsException ex) {
                result.rejectValue("editKeywordName", "preferences.keywordExistsError");
            }
        }
    }

    private void processRemoveKeyword(EditKeywordCommand command) {
        this.facade.getKeywordService().deleteKeyword(Long.valueOf(command.getEditKeywordId()));
        this.clientKeywordService.deleteKeyword(command.getEditKeywordId());
        command.setEditKeywordName("");
    }

    private void processSaveLibraryRoles(SaveLibraryRolesCommand command, BindingResult result, Map<String, Object> model) {
    }

    private void processSaveRoleCategories(SaveRoleCategoriesCommand command, Map<String, Object> model) {
        try {
            Role role = (Role)model.get("currentRole");
            this.facade.getRoleService().assignCategoryRoles(role, command.getAssignedCategoryIds());
        }
        catch (Exception ex) {
            log.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @RequestMapping(value={"/preferences/role"})
    public String changeCurrentRoleHandler(@RequestParam(required=false) Integer id, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Role role;
        User user = SessionUtils.getUser(request, session, this.facade);
        if (user == null) {
            ClientUtils.redirectToLogin(response, this.facade);
            return null;
        }
        if (!ClientUtils.canAccessPreferences(user, this.facade)) {
            return "redirect:/archive";
        }
        if (id != null && (role = this.facade.getRoleService().getRoleById(id.intValue())) != null) {
            session.setAttribute(ROLE_KEY, (Object)role);
        }
        return "redirect:/archive/preferences";
    }

    @RequestMapping(value={"/preferences/library"})
    public String changeCurrentLibraryHander(@RequestParam(required=false) Long id, HttpServletResponse response, HttpSession session) {
        Library library;
        if (id != null && (library = this.facade.getLibraryService().findLibraryById(id)) != null) {
            session.setAttribute(LIBRARY_KEY, (Object)library);
        }
        return "redirect:/archive/preferences";
    }
}

