/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imagearchive.entity;

import com.imcode.imcms.addon.imagearchive.entity.Image;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="archive_keywords")
public class ClientKeyword
implements Serializable,
Comparable<ClientKeyword> {
    private static final long serialVersionUID = -5618267783578349726L;
    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue
    private Long id;
    @Column(name="keyword_nm", length=50, nullable=false)
    private String name;
    @Column(name="created_dt", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDt = new Date();
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @LazyCollection(value=LazyCollectionOption.TRUE)
    @JoinTable(name="archive_image_keywords", inverseJoinColumns={@JoinColumn(name="image_id", nullable=false)}, joinColumns={@JoinColumn(name="keyword_id", nullable=false)})
    private List<Image> images;

    public ClientKeyword() {
    }

    public ClientKeyword(String name) {
        this.name = name;
    }

    @PrePersist
    public void prePersist() {
        this.createdDt = new Date();
    }

    public Date getCreatedDt() {
        return this.createdDt;
    }

    public void setCreatedDt(Date createdDt) {
        this.createdDt = createdDt;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientKeyword)) {
            return false;
        }
        ClientKeyword that = (ClientKeyword)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.createdDt.equals(that.createdDt);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.createdDt.hashCode();
        return result;
    }

    public String toString() {
        return String.format("com.imcode.imcms.addon.imagearchive.entity.ClientKeywords[id: %d, name: %s]", this.id, this.name);
    }

    @Override
    public int compareTo(ClientKeyword o) {
        return this.id.compareTo(o.id);
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }
}

